/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.services.iot.model.AuthorizerStatus;
import software.amazon.awssdk.services.iot.model.IotRequest;
import software.amazon.awssdk.services.iot.model.PublicKeyMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateAuthorizerRequest
extends IotRequest
implements ToCopyableBuilder<Builder, CreateAuthorizerRequest> {
    private final String authorizerName;
    private final String authorizerFunctionArn;
    private final String tokenKeyName;
    private final Map<String, String> tokenSigningPublicKeys;
    private final String status;

    private CreateAuthorizerRequest(BuilderImpl builder) {
        super(builder);
        this.authorizerName = builder.authorizerName;
        this.authorizerFunctionArn = builder.authorizerFunctionArn;
        this.tokenKeyName = builder.tokenKeyName;
        this.tokenSigningPublicKeys = builder.tokenSigningPublicKeys;
        this.status = builder.status;
    }

    public String authorizerName() {
        return this.authorizerName;
    }

    public String authorizerFunctionArn() {
        return this.authorizerFunctionArn;
    }

    public String tokenKeyName() {
        return this.tokenKeyName;
    }

    public Map<String, String> tokenSigningPublicKeys() {
        return this.tokenSigningPublicKeys;
    }

    public AuthorizerStatus status() {
        return AuthorizerStatus.fromValue(this.status);
    }

    public String statusAsString() {
        return this.status;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.authorizerName());
        hashCode = 31 * hashCode + Objects.hashCode(this.authorizerFunctionArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.tokenKeyName());
        hashCode = 31 * hashCode + Objects.hashCode(this.tokenSigningPublicKeys());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateAuthorizerRequest)) {
            return false;
        }
        CreateAuthorizerRequest other = (CreateAuthorizerRequest)((Object)obj);
        return Objects.equals(this.authorizerName(), other.authorizerName()) && Objects.equals(this.authorizerFunctionArn(), other.authorizerFunctionArn()) && Objects.equals(this.tokenKeyName(), other.tokenKeyName()) && Objects.equals(this.tokenSigningPublicKeys(), other.tokenSigningPublicKeys()) && Objects.equals(this.statusAsString(), other.statusAsString());
    }

    public String toString() {
        return ToString.builder((String)"CreateAuthorizerRequest").add("AuthorizerName", (Object)this.authorizerName()).add("AuthorizerFunctionArn", (Object)this.authorizerFunctionArn()).add("TokenKeyName", (Object)this.tokenKeyName()).add("TokenSigningPublicKeys", this.tokenSigningPublicKeys()).add("Status", (Object)this.statusAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "authorizerName": {
                return Optional.ofNullable(clazz.cast(this.authorizerName()));
            }
            case "authorizerFunctionArn": {
                return Optional.ofNullable(clazz.cast(this.authorizerFunctionArn()));
            }
            case "tokenKeyName": {
                return Optional.ofNullable(clazz.cast(this.tokenKeyName()));
            }
            case "tokenSigningPublicKeys": {
                return Optional.ofNullable(clazz.cast(this.tokenSigningPublicKeys()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends IotRequest.BuilderImpl
    implements Builder {
        private String authorizerName;
        private String authorizerFunctionArn;
        private String tokenKeyName;
        private Map<String, String> tokenSigningPublicKeys = DefaultSdkAutoConstructMap.getInstance();
        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateAuthorizerRequest model) {
            super(model);
            this.authorizerName(model.authorizerName);
            this.authorizerFunctionArn(model.authorizerFunctionArn);
            this.tokenKeyName(model.tokenKeyName);
            this.tokenSigningPublicKeys(model.tokenSigningPublicKeys);
            this.status(model.status);
        }

        public final String getAuthorizerName() {
            return this.authorizerName;
        }

        @Override
        public final Builder authorizerName(String authorizerName) {
            this.authorizerName = authorizerName;
            return this;
        }

        public final void setAuthorizerName(String authorizerName) {
            this.authorizerName = authorizerName;
        }

        public final String getAuthorizerFunctionArn() {
            return this.authorizerFunctionArn;
        }

        @Override
        public final Builder authorizerFunctionArn(String authorizerFunctionArn) {
            this.authorizerFunctionArn = authorizerFunctionArn;
            return this;
        }

        public final void setAuthorizerFunctionArn(String authorizerFunctionArn) {
            this.authorizerFunctionArn = authorizerFunctionArn;
        }

        public final String getTokenKeyName() {
            return this.tokenKeyName;
        }

        @Override
        public final Builder tokenKeyName(String tokenKeyName) {
            this.tokenKeyName = tokenKeyName;
            return this;
        }

        public final void setTokenKeyName(String tokenKeyName) {
            this.tokenKeyName = tokenKeyName;
        }

        public final Map<String, String> getTokenSigningPublicKeys() {
            return this.tokenSigningPublicKeys;
        }

        @Override
        public final Builder tokenSigningPublicKeys(Map<String, String> tokenSigningPublicKeys) {
            this.tokenSigningPublicKeys = PublicKeyMapCopier.copy(tokenSigningPublicKeys);
            return this;
        }

        public final void setTokenSigningPublicKeys(Map<String, String> tokenSigningPublicKeys) {
            this.tokenSigningPublicKeys = PublicKeyMapCopier.copy(tokenSigningPublicKeys);
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(AuthorizerStatus status) {
            this.status(status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateAuthorizerRequest build() {
            return new CreateAuthorizerRequest(this);
        }
    }

    public static interface Builder
    extends IotRequest.Builder,
    CopyableBuilder<Builder, CreateAuthorizerRequest> {
        public Builder authorizerName(String var1);

        public Builder authorizerFunctionArn(String var1);

        public Builder tokenKeyName(String var1);

        public Builder tokenSigningPublicKeys(Map<String, String> var1);

        public Builder status(String var1);

        public Builder status(AuthorizerStatus var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

