/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.services.iot.model.IotRequest;
import software.amazon.awssdk.services.iot.model.ThingGroupProperties;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateThingGroupRequest
extends IotRequest
implements ToCopyableBuilder<Builder, CreateThingGroupRequest> {
    private final String thingGroupName;
    private final String parentGroupName;
    private final ThingGroupProperties thingGroupProperties;

    private CreateThingGroupRequest(BuilderImpl builder) {
        super(builder);
        this.thingGroupName = builder.thingGroupName;
        this.parentGroupName = builder.parentGroupName;
        this.thingGroupProperties = builder.thingGroupProperties;
    }

    public String thingGroupName() {
        return this.thingGroupName;
    }

    public String parentGroupName() {
        return this.parentGroupName;
    }

    public ThingGroupProperties thingGroupProperties() {
        return this.thingGroupProperties;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.thingGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.parentGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.thingGroupProperties());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateThingGroupRequest)) {
            return false;
        }
        CreateThingGroupRequest other = (CreateThingGroupRequest)((Object)obj);
        return Objects.equals(this.thingGroupName(), other.thingGroupName()) && Objects.equals(this.parentGroupName(), other.parentGroupName()) && Objects.equals(this.thingGroupProperties(), other.thingGroupProperties());
    }

    public String toString() {
        return ToString.builder((String)"CreateThingGroupRequest").add("ThingGroupName", (Object)this.thingGroupName()).add("ParentGroupName", (Object)this.parentGroupName()).add("ThingGroupProperties", (Object)this.thingGroupProperties()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "thingGroupName": {
                return Optional.ofNullable(clazz.cast(this.thingGroupName()));
            }
            case "parentGroupName": {
                return Optional.ofNullable(clazz.cast(this.parentGroupName()));
            }
            case "thingGroupProperties": {
                return Optional.ofNullable(clazz.cast(this.thingGroupProperties()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends IotRequest.BuilderImpl
    implements Builder {
        private String thingGroupName;
        private String parentGroupName;
        private ThingGroupProperties thingGroupProperties;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateThingGroupRequest model) {
            super(model);
            this.thingGroupName(model.thingGroupName);
            this.parentGroupName(model.parentGroupName);
            this.thingGroupProperties(model.thingGroupProperties);
        }

        public final String getThingGroupName() {
            return this.thingGroupName;
        }

        @Override
        public final Builder thingGroupName(String thingGroupName) {
            this.thingGroupName = thingGroupName;
            return this;
        }

        public final void setThingGroupName(String thingGroupName) {
            this.thingGroupName = thingGroupName;
        }

        public final String getParentGroupName() {
            return this.parentGroupName;
        }

        @Override
        public final Builder parentGroupName(String parentGroupName) {
            this.parentGroupName = parentGroupName;
            return this;
        }

        public final void setParentGroupName(String parentGroupName) {
            this.parentGroupName = parentGroupName;
        }

        public final ThingGroupProperties.Builder getThingGroupProperties() {
            return this.thingGroupProperties != null ? this.thingGroupProperties.toBuilder() : null;
        }

        @Override
        public final Builder thingGroupProperties(ThingGroupProperties thingGroupProperties) {
            this.thingGroupProperties = thingGroupProperties;
            return this;
        }

        public final void setThingGroupProperties(ThingGroupProperties.BuilderImpl thingGroupProperties) {
            this.thingGroupProperties = thingGroupProperties != null ? thingGroupProperties.build() : null;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateThingGroupRequest build() {
            return new CreateThingGroupRequest(this);
        }
    }

    public static interface Builder
    extends IotRequest.Builder,
    CopyableBuilder<Builder, CreateThingGroupRequest> {
        public Builder thingGroupName(String var1);

        public Builder parentGroupName(String var1);

        public Builder thingGroupProperties(ThingGroupProperties var1);

        default public Builder thingGroupProperties(Consumer<ThingGroupProperties.Builder> thingGroupProperties) {
            return this.thingGroupProperties((ThingGroupProperties)((ThingGroupProperties.Builder)ThingGroupProperties.builder().applyMutation(thingGroupProperties)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

