/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.time.Instant;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.services.iot.model.AuditCheckDetails;
import software.amazon.awssdk.services.iot.model.AuditDetailsCopier;
import software.amazon.awssdk.services.iot.model.AuditTaskStatus;
import software.amazon.awssdk.services.iot.model.AuditTaskType;
import software.amazon.awssdk.services.iot.model.IotResponse;
import software.amazon.awssdk.services.iot.model.TaskStatistics;
import software.amazon.awssdk.utils.CollectionUtils;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeAuditTaskResponse
extends IotResponse
implements ToCopyableBuilder<Builder, DescribeAuditTaskResponse> {
    private final String taskStatus;
    private final String taskType;
    private final Instant taskStartTime;
    private final TaskStatistics taskStatistics;
    private final String scheduledAuditName;
    private final Map<String, AuditCheckDetails> auditDetails;

    private DescribeAuditTaskResponse(BuilderImpl builder) {
        super(builder);
        this.taskStatus = builder.taskStatus;
        this.taskType = builder.taskType;
        this.taskStartTime = builder.taskStartTime;
        this.taskStatistics = builder.taskStatistics;
        this.scheduledAuditName = builder.scheduledAuditName;
        this.auditDetails = builder.auditDetails;
    }

    public AuditTaskStatus taskStatus() {
        return AuditTaskStatus.fromValue(this.taskStatus);
    }

    public String taskStatusAsString() {
        return this.taskStatus;
    }

    public AuditTaskType taskType() {
        return AuditTaskType.fromValue(this.taskType);
    }

    public String taskTypeAsString() {
        return this.taskType;
    }

    public Instant taskStartTime() {
        return this.taskStartTime;
    }

    public TaskStatistics taskStatistics() {
        return this.taskStatistics;
    }

    public String scheduledAuditName() {
        return this.scheduledAuditName;
    }

    public Map<String, AuditCheckDetails> auditDetails() {
        return this.auditDetails;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.taskStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.taskTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.taskStartTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.taskStatistics());
        hashCode = 31 * hashCode + Objects.hashCode(this.scheduledAuditName());
        hashCode = 31 * hashCode + Objects.hashCode(this.auditDetails());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeAuditTaskResponse)) {
            return false;
        }
        DescribeAuditTaskResponse other = (DescribeAuditTaskResponse)((Object)obj);
        return Objects.equals(this.taskStatusAsString(), other.taskStatusAsString()) && Objects.equals(this.taskTypeAsString(), other.taskTypeAsString()) && Objects.equals(this.taskStartTime(), other.taskStartTime()) && Objects.equals(this.taskStatistics(), other.taskStatistics()) && Objects.equals(this.scheduledAuditName(), other.scheduledAuditName()) && Objects.equals(this.auditDetails(), other.auditDetails());
    }

    public String toString() {
        return ToString.builder((String)"DescribeAuditTaskResponse").add("TaskStatus", (Object)this.taskStatusAsString()).add("TaskType", (Object)this.taskTypeAsString()).add("TaskStartTime", (Object)this.taskStartTime()).add("TaskStatistics", (Object)this.taskStatistics()).add("ScheduledAuditName", (Object)this.scheduledAuditName()).add("AuditDetails", this.auditDetails()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "taskStatus": {
                return Optional.ofNullable(clazz.cast(this.taskStatusAsString()));
            }
            case "taskType": {
                return Optional.ofNullable(clazz.cast(this.taskTypeAsString()));
            }
            case "taskStartTime": {
                return Optional.ofNullable(clazz.cast(this.taskStartTime()));
            }
            case "taskStatistics": {
                return Optional.ofNullable(clazz.cast(this.taskStatistics()));
            }
            case "scheduledAuditName": {
                return Optional.ofNullable(clazz.cast(this.scheduledAuditName()));
            }
            case "auditDetails": {
                return Optional.ofNullable(clazz.cast(this.auditDetails()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends IotResponse.BuilderImpl
    implements Builder {
        private String taskStatus;
        private String taskType;
        private Instant taskStartTime;
        private TaskStatistics taskStatistics;
        private String scheduledAuditName;
        private Map<String, AuditCheckDetails> auditDetails = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeAuditTaskResponse model) {
            super(model);
            this.taskStatus(model.taskStatus);
            this.taskType(model.taskType);
            this.taskStartTime(model.taskStartTime);
            this.taskStatistics(model.taskStatistics);
            this.scheduledAuditName(model.scheduledAuditName);
            this.auditDetails(model.auditDetails);
        }

        public final String getTaskStatus() {
            return this.taskStatus;
        }

        @Override
        public final Builder taskStatus(String taskStatus) {
            this.taskStatus = taskStatus;
            return this;
        }

        @Override
        public final Builder taskStatus(AuditTaskStatus taskStatus) {
            this.taskStatus(taskStatus.toString());
            return this;
        }

        public final void setTaskStatus(String taskStatus) {
            this.taskStatus = taskStatus;
        }

        public final String getTaskType() {
            return this.taskType;
        }

        @Override
        public final Builder taskType(String taskType) {
            this.taskType = taskType;
            return this;
        }

        @Override
        public final Builder taskType(AuditTaskType taskType) {
            this.taskType(taskType.toString());
            return this;
        }

        public final void setTaskType(String taskType) {
            this.taskType = taskType;
        }

        public final Instant getTaskStartTime() {
            return this.taskStartTime;
        }

        @Override
        public final Builder taskStartTime(Instant taskStartTime) {
            this.taskStartTime = taskStartTime;
            return this;
        }

        public final void setTaskStartTime(Instant taskStartTime) {
            this.taskStartTime = taskStartTime;
        }

        public final TaskStatistics.Builder getTaskStatistics() {
            return this.taskStatistics != null ? this.taskStatistics.toBuilder() : null;
        }

        @Override
        public final Builder taskStatistics(TaskStatistics taskStatistics) {
            this.taskStatistics = taskStatistics;
            return this;
        }

        public final void setTaskStatistics(TaskStatistics.BuilderImpl taskStatistics) {
            this.taskStatistics = taskStatistics != null ? taskStatistics.build() : null;
        }

        public final String getScheduledAuditName() {
            return this.scheduledAuditName;
        }

        @Override
        public final Builder scheduledAuditName(String scheduledAuditName) {
            this.scheduledAuditName = scheduledAuditName;
            return this;
        }

        public final void setScheduledAuditName(String scheduledAuditName) {
            this.scheduledAuditName = scheduledAuditName;
        }

        public final Map<String, AuditCheckDetails.Builder> getAuditDetails() {
            return this.auditDetails != null ? CollectionUtils.mapValues(this.auditDetails, AuditCheckDetails::toBuilder) : null;
        }

        @Override
        public final Builder auditDetails(Map<String, AuditCheckDetails> auditDetails) {
            this.auditDetails = AuditDetailsCopier.copy(auditDetails);
            return this;
        }

        public final void setAuditDetails(Map<String, AuditCheckDetails.BuilderImpl> auditDetails) {
            this.auditDetails = AuditDetailsCopier.copyFromBuilder(auditDetails);
        }

        @Override
        public DescribeAuditTaskResponse build() {
            return new DescribeAuditTaskResponse(this);
        }
    }

    public static interface Builder
    extends IotResponse.Builder,
    CopyableBuilder<Builder, DescribeAuditTaskResponse> {
        public Builder taskStatus(String var1);

        public Builder taskStatus(AuditTaskStatus var1);

        public Builder taskType(String var1);

        public Builder taskType(AuditTaskType var1);

        public Builder taskStartTime(Instant var1);

        public Builder taskStatistics(TaskStatistics var1);

        default public Builder taskStatistics(Consumer<TaskStatistics.Builder> taskStatistics) {
            return this.taskStatistics((TaskStatistics)((TaskStatistics.Builder)TaskStatistics.builder().applyMutation(taskStatistics)).build());
        }

        public Builder scheduledAuditName(String var1);

        public Builder auditDetails(Map<String, AuditCheckDetails> var1);
    }
}

