/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.time.Instant;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.services.iot.model.IotResponse;
import software.amazon.awssdk.services.iot.model.Status;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeThingRegistrationTaskResponse
extends IotResponse
implements ToCopyableBuilder<Builder, DescribeThingRegistrationTaskResponse> {
    private final String taskId;
    private final Instant creationDate;
    private final Instant lastModifiedDate;
    private final String templateBody;
    private final String inputFileBucket;
    private final String inputFileKey;
    private final String roleArn;
    private final String status;
    private final String message;
    private final Integer successCount;
    private final Integer failureCount;
    private final Integer percentageProgress;

    private DescribeThingRegistrationTaskResponse(BuilderImpl builder) {
        super(builder);
        this.taskId = builder.taskId;
        this.creationDate = builder.creationDate;
        this.lastModifiedDate = builder.lastModifiedDate;
        this.templateBody = builder.templateBody;
        this.inputFileBucket = builder.inputFileBucket;
        this.inputFileKey = builder.inputFileKey;
        this.roleArn = builder.roleArn;
        this.status = builder.status;
        this.message = builder.message;
        this.successCount = builder.successCount;
        this.failureCount = builder.failureCount;
        this.percentageProgress = builder.percentageProgress;
    }

    public String taskId() {
        return this.taskId;
    }

    public Instant creationDate() {
        return this.creationDate;
    }

    public Instant lastModifiedDate() {
        return this.lastModifiedDate;
    }

    public String templateBody() {
        return this.templateBody;
    }

    public String inputFileBucket() {
        return this.inputFileBucket;
    }

    public String inputFileKey() {
        return this.inputFileKey;
    }

    public String roleArn() {
        return this.roleArn;
    }

    public Status status() {
        return Status.fromValue(this.status);
    }

    public String statusAsString() {
        return this.status;
    }

    public String message() {
        return this.message;
    }

    public Integer successCount() {
        return this.successCount;
    }

    public Integer failureCount() {
        return this.failureCount;
    }

    public Integer percentageProgress() {
        return this.percentageProgress;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.taskId());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModifiedDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.templateBody());
        hashCode = 31 * hashCode + Objects.hashCode(this.inputFileBucket());
        hashCode = 31 * hashCode + Objects.hashCode(this.inputFileKey());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.message());
        hashCode = 31 * hashCode + Objects.hashCode(this.successCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.failureCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.percentageProgress());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeThingRegistrationTaskResponse)) {
            return false;
        }
        DescribeThingRegistrationTaskResponse other = (DescribeThingRegistrationTaskResponse)((Object)obj);
        return Objects.equals(this.taskId(), other.taskId()) && Objects.equals(this.creationDate(), other.creationDate()) && Objects.equals(this.lastModifiedDate(), other.lastModifiedDate()) && Objects.equals(this.templateBody(), other.templateBody()) && Objects.equals(this.inputFileBucket(), other.inputFileBucket()) && Objects.equals(this.inputFileKey(), other.inputFileKey()) && Objects.equals(this.roleArn(), other.roleArn()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.message(), other.message()) && Objects.equals(this.successCount(), other.successCount()) && Objects.equals(this.failureCount(), other.failureCount()) && Objects.equals(this.percentageProgress(), other.percentageProgress());
    }

    public String toString() {
        return ToString.builder((String)"DescribeThingRegistrationTaskResponse").add("TaskId", (Object)this.taskId()).add("CreationDate", (Object)this.creationDate()).add("LastModifiedDate", (Object)this.lastModifiedDate()).add("TemplateBody", (Object)this.templateBody()).add("InputFileBucket", (Object)this.inputFileBucket()).add("InputFileKey", (Object)this.inputFileKey()).add("RoleArn", (Object)this.roleArn()).add("Status", (Object)this.statusAsString()).add("Message", (Object)this.message()).add("SuccessCount", (Object)this.successCount()).add("FailureCount", (Object)this.failureCount()).add("PercentageProgress", (Object)this.percentageProgress()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "taskId": {
                return Optional.ofNullable(clazz.cast(this.taskId()));
            }
            case "creationDate": {
                return Optional.ofNullable(clazz.cast(this.creationDate()));
            }
            case "lastModifiedDate": {
                return Optional.ofNullable(clazz.cast(this.lastModifiedDate()));
            }
            case "templateBody": {
                return Optional.ofNullable(clazz.cast(this.templateBody()));
            }
            case "inputFileBucket": {
                return Optional.ofNullable(clazz.cast(this.inputFileBucket()));
            }
            case "inputFileKey": {
                return Optional.ofNullable(clazz.cast(this.inputFileKey()));
            }
            case "roleArn": {
                return Optional.ofNullable(clazz.cast(this.roleArn()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "message": {
                return Optional.ofNullable(clazz.cast(this.message()));
            }
            case "successCount": {
                return Optional.ofNullable(clazz.cast(this.successCount()));
            }
            case "failureCount": {
                return Optional.ofNullable(clazz.cast(this.failureCount()));
            }
            case "percentageProgress": {
                return Optional.ofNullable(clazz.cast(this.percentageProgress()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends IotResponse.BuilderImpl
    implements Builder {
        private String taskId;
        private Instant creationDate;
        private Instant lastModifiedDate;
        private String templateBody;
        private String inputFileBucket;
        private String inputFileKey;
        private String roleArn;
        private String status;
        private String message;
        private Integer successCount;
        private Integer failureCount;
        private Integer percentageProgress;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeThingRegistrationTaskResponse model) {
            super(model);
            this.taskId(model.taskId);
            this.creationDate(model.creationDate);
            this.lastModifiedDate(model.lastModifiedDate);
            this.templateBody(model.templateBody);
            this.inputFileBucket(model.inputFileBucket);
            this.inputFileKey(model.inputFileKey);
            this.roleArn(model.roleArn);
            this.status(model.status);
            this.message(model.message);
            this.successCount(model.successCount);
            this.failureCount(model.failureCount);
            this.percentageProgress(model.percentageProgress);
        }

        public final String getTaskId() {
            return this.taskId;
        }

        @Override
        public final Builder taskId(String taskId) {
            this.taskId = taskId;
            return this;
        }

        public final void setTaskId(String taskId) {
            this.taskId = taskId;
        }

        public final Instant getCreationDate() {
            return this.creationDate;
        }

        @Override
        public final Builder creationDate(Instant creationDate) {
            this.creationDate = creationDate;
            return this;
        }

        public final void setCreationDate(Instant creationDate) {
            this.creationDate = creationDate;
        }

        public final Instant getLastModifiedDate() {
            return this.lastModifiedDate;
        }

        @Override
        public final Builder lastModifiedDate(Instant lastModifiedDate) {
            this.lastModifiedDate = lastModifiedDate;
            return this;
        }

        public final void setLastModifiedDate(Instant lastModifiedDate) {
            this.lastModifiedDate = lastModifiedDate;
        }

        public final String getTemplateBody() {
            return this.templateBody;
        }

        @Override
        public final Builder templateBody(String templateBody) {
            this.templateBody = templateBody;
            return this;
        }

        public final void setTemplateBody(String templateBody) {
            this.templateBody = templateBody;
        }

        public final String getInputFileBucket() {
            return this.inputFileBucket;
        }

        @Override
        public final Builder inputFileBucket(String inputFileBucket) {
            this.inputFileBucket = inputFileBucket;
            return this;
        }

        public final void setInputFileBucket(String inputFileBucket) {
            this.inputFileBucket = inputFileBucket;
        }

        public final String getInputFileKey() {
            return this.inputFileKey;
        }

        @Override
        public final Builder inputFileKey(String inputFileKey) {
            this.inputFileKey = inputFileKey;
            return this;
        }

        public final void setInputFileKey(String inputFileKey) {
            this.inputFileKey = inputFileKey;
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(Status status) {
            this.status(status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final String getMessage() {
            return this.message;
        }

        @Override
        public final Builder message(String message) {
            this.message = message;
            return this;
        }

        public final void setMessage(String message) {
            this.message = message;
        }

        public final Integer getSuccessCount() {
            return this.successCount;
        }

        @Override
        public final Builder successCount(Integer successCount) {
            this.successCount = successCount;
            return this;
        }

        public final void setSuccessCount(Integer successCount) {
            this.successCount = successCount;
        }

        public final Integer getFailureCount() {
            return this.failureCount;
        }

        @Override
        public final Builder failureCount(Integer failureCount) {
            this.failureCount = failureCount;
            return this;
        }

        public final void setFailureCount(Integer failureCount) {
            this.failureCount = failureCount;
        }

        public final Integer getPercentageProgress() {
            return this.percentageProgress;
        }

        @Override
        public final Builder percentageProgress(Integer percentageProgress) {
            this.percentageProgress = percentageProgress;
            return this;
        }

        public final void setPercentageProgress(Integer percentageProgress) {
            this.percentageProgress = percentageProgress;
        }

        @Override
        public DescribeThingRegistrationTaskResponse build() {
            return new DescribeThingRegistrationTaskResponse(this);
        }
    }

    public static interface Builder
    extends IotResponse.Builder,
    CopyableBuilder<Builder, DescribeThingRegistrationTaskResponse> {
        public Builder taskId(String var1);

        public Builder creationDate(Instant var1);

        public Builder lastModifiedDate(Instant var1);

        public Builder templateBody(String var1);

        public Builder inputFileBucket(String var1);

        public Builder inputFileKey(String var1);

        public Builder roleArn(String var1);

        public Builder status(String var1);

        public Builder status(Status var1);

        public Builder message(String var1);

        public Builder successCount(Integer var1);

        public Builder failureCount(Integer var1);

        public Builder percentageProgress(Integer var1);
    }
}

