/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.services.iot.model.IotRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DetachSecurityProfileRequest
extends IotRequest
implements ToCopyableBuilder<Builder, DetachSecurityProfileRequest> {
    private final String securityProfileName;
    private final String securityProfileTargetArn;

    private DetachSecurityProfileRequest(BuilderImpl builder) {
        super(builder);
        this.securityProfileName = builder.securityProfileName;
        this.securityProfileTargetArn = builder.securityProfileTargetArn;
    }

    public String securityProfileName() {
        return this.securityProfileName;
    }

    public String securityProfileTargetArn() {
        return this.securityProfileTargetArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.securityProfileName());
        hashCode = 31 * hashCode + Objects.hashCode(this.securityProfileTargetArn());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DetachSecurityProfileRequest)) {
            return false;
        }
        DetachSecurityProfileRequest other = (DetachSecurityProfileRequest)((Object)obj);
        return Objects.equals(this.securityProfileName(), other.securityProfileName()) && Objects.equals(this.securityProfileTargetArn(), other.securityProfileTargetArn());
    }

    public String toString() {
        return ToString.builder((String)"DetachSecurityProfileRequest").add("SecurityProfileName", (Object)this.securityProfileName()).add("SecurityProfileTargetArn", (Object)this.securityProfileTargetArn()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "securityProfileName": {
                return Optional.ofNullable(clazz.cast(this.securityProfileName()));
            }
            case "securityProfileTargetArn": {
                return Optional.ofNullable(clazz.cast(this.securityProfileTargetArn()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends IotRequest.BuilderImpl
    implements Builder {
        private String securityProfileName;
        private String securityProfileTargetArn;

        private BuilderImpl() {
        }

        private BuilderImpl(DetachSecurityProfileRequest model) {
            super(model);
            this.securityProfileName(model.securityProfileName);
            this.securityProfileTargetArn(model.securityProfileTargetArn);
        }

        public final String getSecurityProfileName() {
            return this.securityProfileName;
        }

        @Override
        public final Builder securityProfileName(String securityProfileName) {
            this.securityProfileName = securityProfileName;
            return this;
        }

        public final void setSecurityProfileName(String securityProfileName) {
            this.securityProfileName = securityProfileName;
        }

        public final String getSecurityProfileTargetArn() {
            return this.securityProfileTargetArn;
        }

        @Override
        public final Builder securityProfileTargetArn(String securityProfileTargetArn) {
            this.securityProfileTargetArn = securityProfileTargetArn;
            return this;
        }

        public final void setSecurityProfileTargetArn(String securityProfileTargetArn) {
            this.securityProfileTargetArn = securityProfileTargetArn;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DetachSecurityProfileRequest build() {
            return new DetachSecurityProfileRequest(this);
        }
    }

    public static interface Builder
    extends IotRequest.Builder,
    CopyableBuilder<Builder, DetachSecurityProfileRequest> {
        public Builder securityProfileName(String var1);

        public Builder securityProfileTargetArn(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

