/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.iot.transform.GroupNameAndArnMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GroupNameAndArn
implements StructuredPojo,
ToCopyableBuilder<Builder, GroupNameAndArn> {
    private final String groupName;
    private final String groupArn;

    private GroupNameAndArn(BuilderImpl builder) {
        this.groupName = builder.groupName;
        this.groupArn = builder.groupArn;
    }

    public String groupName() {
        return this.groupName;
    }

    public String groupArn() {
        return this.groupArn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.groupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.groupArn());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GroupNameAndArn)) {
            return false;
        }
        GroupNameAndArn other = (GroupNameAndArn)obj;
        return Objects.equals(this.groupName(), other.groupName()) && Objects.equals(this.groupArn(), other.groupArn());
    }

    public String toString() {
        return ToString.builder((String)"GroupNameAndArn").add("GroupName", (Object)this.groupName()).add("GroupArn", (Object)this.groupArn()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "groupName": {
                return Optional.ofNullable(clazz.cast(this.groupName()));
            }
            case "groupArn": {
                return Optional.ofNullable(clazz.cast(this.groupArn()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        GroupNameAndArnMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String groupName;
        private String groupArn;

        private BuilderImpl() {
        }

        private BuilderImpl(GroupNameAndArn model) {
            this.groupName(model.groupName);
            this.groupArn(model.groupArn);
        }

        public final String getGroupName() {
            return this.groupName;
        }

        @Override
        public final Builder groupName(String groupName) {
            this.groupName = groupName;
            return this;
        }

        public final void setGroupName(String groupName) {
            this.groupName = groupName;
        }

        public final String getGroupArn() {
            return this.groupArn;
        }

        @Override
        public final Builder groupArn(String groupArn) {
            this.groupArn = groupArn;
            return this;
        }

        public final void setGroupArn(String groupArn) {
            this.groupArn = groupArn;
        }

        public GroupNameAndArn build() {
            return new GroupNameAndArn(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, GroupNameAndArn> {
        public Builder groupName(String var1);

        public Builder groupArn(String var1);
    }
}

