/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.iot.transform.IotAnalyticsActionMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class IotAnalyticsAction
implements StructuredPojo,
ToCopyableBuilder<Builder, IotAnalyticsAction> {
    private final String channelArn;
    private final String channelName;
    private final String roleArn;

    private IotAnalyticsAction(BuilderImpl builder) {
        this.channelArn = builder.channelArn;
        this.channelName = builder.channelName;
        this.roleArn = builder.roleArn;
    }

    public String channelArn() {
        return this.channelArn;
    }

    public String channelName() {
        return this.channelName;
    }

    public String roleArn() {
        return this.roleArn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.channelArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.channelName());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleArn());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IotAnalyticsAction)) {
            return false;
        }
        IotAnalyticsAction other = (IotAnalyticsAction)obj;
        return Objects.equals(this.channelArn(), other.channelArn()) && Objects.equals(this.channelName(), other.channelName()) && Objects.equals(this.roleArn(), other.roleArn());
    }

    public String toString() {
        return ToString.builder((String)"IotAnalyticsAction").add("ChannelArn", (Object)this.channelArn()).add("ChannelName", (Object)this.channelName()).add("RoleArn", (Object)this.roleArn()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "channelArn": {
                return Optional.ofNullable(clazz.cast(this.channelArn()));
            }
            case "channelName": {
                return Optional.ofNullable(clazz.cast(this.channelName()));
            }
            case "roleArn": {
                return Optional.ofNullable(clazz.cast(this.roleArn()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        IotAnalyticsActionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String channelArn;
        private String channelName;
        private String roleArn;

        private BuilderImpl() {
        }

        private BuilderImpl(IotAnalyticsAction model) {
            this.channelArn(model.channelArn);
            this.channelName(model.channelName);
            this.roleArn(model.roleArn);
        }

        public final String getChannelArn() {
            return this.channelArn;
        }

        @Override
        public final Builder channelArn(String channelArn) {
            this.channelArn = channelArn;
            return this;
        }

        public final void setChannelArn(String channelArn) {
            this.channelArn = channelArn;
        }

        public final String getChannelName() {
            return this.channelName;
        }

        @Override
        public final Builder channelName(String channelName) {
            this.channelName = channelName;
            return this;
        }

        public final void setChannelName(String channelName) {
            this.channelName = channelName;
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        public IotAnalyticsAction build() {
            return new IotAnalyticsAction(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, IotAnalyticsAction> {
        public Builder channelArn(String var1);

        public Builder channelName(String var1);

        public Builder roleArn(String var1);
    }
}

