/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.iot.model.ProcessingTargetNameListCopier;
import software.amazon.awssdk.services.iot.transform.JobProcessDetailsMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class JobProcessDetails
implements StructuredPojo,
ToCopyableBuilder<Builder, JobProcessDetails> {
    private final List<String> processingTargets;
    private final Integer numberOfCanceledThings;
    private final Integer numberOfSucceededThings;
    private final Integer numberOfFailedThings;
    private final Integer numberOfRejectedThings;
    private final Integer numberOfQueuedThings;
    private final Integer numberOfInProgressThings;
    private final Integer numberOfRemovedThings;

    private JobProcessDetails(BuilderImpl builder) {
        this.processingTargets = builder.processingTargets;
        this.numberOfCanceledThings = builder.numberOfCanceledThings;
        this.numberOfSucceededThings = builder.numberOfSucceededThings;
        this.numberOfFailedThings = builder.numberOfFailedThings;
        this.numberOfRejectedThings = builder.numberOfRejectedThings;
        this.numberOfQueuedThings = builder.numberOfQueuedThings;
        this.numberOfInProgressThings = builder.numberOfInProgressThings;
        this.numberOfRemovedThings = builder.numberOfRemovedThings;
    }

    public List<String> processingTargets() {
        return this.processingTargets;
    }

    public Integer numberOfCanceledThings() {
        return this.numberOfCanceledThings;
    }

    public Integer numberOfSucceededThings() {
        return this.numberOfSucceededThings;
    }

    public Integer numberOfFailedThings() {
        return this.numberOfFailedThings;
    }

    public Integer numberOfRejectedThings() {
        return this.numberOfRejectedThings;
    }

    public Integer numberOfQueuedThings() {
        return this.numberOfQueuedThings;
    }

    public Integer numberOfInProgressThings() {
        return this.numberOfInProgressThings;
    }

    public Integer numberOfRemovedThings() {
        return this.numberOfRemovedThings;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.processingTargets());
        hashCode = 31 * hashCode + Objects.hashCode(this.numberOfCanceledThings());
        hashCode = 31 * hashCode + Objects.hashCode(this.numberOfSucceededThings());
        hashCode = 31 * hashCode + Objects.hashCode(this.numberOfFailedThings());
        hashCode = 31 * hashCode + Objects.hashCode(this.numberOfRejectedThings());
        hashCode = 31 * hashCode + Objects.hashCode(this.numberOfQueuedThings());
        hashCode = 31 * hashCode + Objects.hashCode(this.numberOfInProgressThings());
        hashCode = 31 * hashCode + Objects.hashCode(this.numberOfRemovedThings());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof JobProcessDetails)) {
            return false;
        }
        JobProcessDetails other = (JobProcessDetails)obj;
        return Objects.equals(this.processingTargets(), other.processingTargets()) && Objects.equals(this.numberOfCanceledThings(), other.numberOfCanceledThings()) && Objects.equals(this.numberOfSucceededThings(), other.numberOfSucceededThings()) && Objects.equals(this.numberOfFailedThings(), other.numberOfFailedThings()) && Objects.equals(this.numberOfRejectedThings(), other.numberOfRejectedThings()) && Objects.equals(this.numberOfQueuedThings(), other.numberOfQueuedThings()) && Objects.equals(this.numberOfInProgressThings(), other.numberOfInProgressThings()) && Objects.equals(this.numberOfRemovedThings(), other.numberOfRemovedThings());
    }

    public String toString() {
        return ToString.builder((String)"JobProcessDetails").add("ProcessingTargets", this.processingTargets()).add("NumberOfCanceledThings", (Object)this.numberOfCanceledThings()).add("NumberOfSucceededThings", (Object)this.numberOfSucceededThings()).add("NumberOfFailedThings", (Object)this.numberOfFailedThings()).add("NumberOfRejectedThings", (Object)this.numberOfRejectedThings()).add("NumberOfQueuedThings", (Object)this.numberOfQueuedThings()).add("NumberOfInProgressThings", (Object)this.numberOfInProgressThings()).add("NumberOfRemovedThings", (Object)this.numberOfRemovedThings()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "processingTargets": {
                return Optional.ofNullable(clazz.cast(this.processingTargets()));
            }
            case "numberOfCanceledThings": {
                return Optional.ofNullable(clazz.cast(this.numberOfCanceledThings()));
            }
            case "numberOfSucceededThings": {
                return Optional.ofNullable(clazz.cast(this.numberOfSucceededThings()));
            }
            case "numberOfFailedThings": {
                return Optional.ofNullable(clazz.cast(this.numberOfFailedThings()));
            }
            case "numberOfRejectedThings": {
                return Optional.ofNullable(clazz.cast(this.numberOfRejectedThings()));
            }
            case "numberOfQueuedThings": {
                return Optional.ofNullable(clazz.cast(this.numberOfQueuedThings()));
            }
            case "numberOfInProgressThings": {
                return Optional.ofNullable(clazz.cast(this.numberOfInProgressThings()));
            }
            case "numberOfRemovedThings": {
                return Optional.ofNullable(clazz.cast(this.numberOfRemovedThings()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        JobProcessDetailsMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> processingTargets = DefaultSdkAutoConstructList.getInstance();
        private Integer numberOfCanceledThings;
        private Integer numberOfSucceededThings;
        private Integer numberOfFailedThings;
        private Integer numberOfRejectedThings;
        private Integer numberOfQueuedThings;
        private Integer numberOfInProgressThings;
        private Integer numberOfRemovedThings;

        private BuilderImpl() {
        }

        private BuilderImpl(JobProcessDetails model) {
            this.processingTargets(model.processingTargets);
            this.numberOfCanceledThings(model.numberOfCanceledThings);
            this.numberOfSucceededThings(model.numberOfSucceededThings);
            this.numberOfFailedThings(model.numberOfFailedThings);
            this.numberOfRejectedThings(model.numberOfRejectedThings);
            this.numberOfQueuedThings(model.numberOfQueuedThings);
            this.numberOfInProgressThings(model.numberOfInProgressThings);
            this.numberOfRemovedThings(model.numberOfRemovedThings);
        }

        public final Collection<String> getProcessingTargets() {
            return this.processingTargets;
        }

        @Override
        public final Builder processingTargets(Collection<String> processingTargets) {
            this.processingTargets = ProcessingTargetNameListCopier.copy(processingTargets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder processingTargets(String ... processingTargets) {
            this.processingTargets(Arrays.asList(processingTargets));
            return this;
        }

        public final void setProcessingTargets(Collection<String> processingTargets) {
            this.processingTargets = ProcessingTargetNameListCopier.copy(processingTargets);
        }

        public final Integer getNumberOfCanceledThings() {
            return this.numberOfCanceledThings;
        }

        @Override
        public final Builder numberOfCanceledThings(Integer numberOfCanceledThings) {
            this.numberOfCanceledThings = numberOfCanceledThings;
            return this;
        }

        public final void setNumberOfCanceledThings(Integer numberOfCanceledThings) {
            this.numberOfCanceledThings = numberOfCanceledThings;
        }

        public final Integer getNumberOfSucceededThings() {
            return this.numberOfSucceededThings;
        }

        @Override
        public final Builder numberOfSucceededThings(Integer numberOfSucceededThings) {
            this.numberOfSucceededThings = numberOfSucceededThings;
            return this;
        }

        public final void setNumberOfSucceededThings(Integer numberOfSucceededThings) {
            this.numberOfSucceededThings = numberOfSucceededThings;
        }

        public final Integer getNumberOfFailedThings() {
            return this.numberOfFailedThings;
        }

        @Override
        public final Builder numberOfFailedThings(Integer numberOfFailedThings) {
            this.numberOfFailedThings = numberOfFailedThings;
            return this;
        }

        public final void setNumberOfFailedThings(Integer numberOfFailedThings) {
            this.numberOfFailedThings = numberOfFailedThings;
        }

        public final Integer getNumberOfRejectedThings() {
            return this.numberOfRejectedThings;
        }

        @Override
        public final Builder numberOfRejectedThings(Integer numberOfRejectedThings) {
            this.numberOfRejectedThings = numberOfRejectedThings;
            return this;
        }

        public final void setNumberOfRejectedThings(Integer numberOfRejectedThings) {
            this.numberOfRejectedThings = numberOfRejectedThings;
        }

        public final Integer getNumberOfQueuedThings() {
            return this.numberOfQueuedThings;
        }

        @Override
        public final Builder numberOfQueuedThings(Integer numberOfQueuedThings) {
            this.numberOfQueuedThings = numberOfQueuedThings;
            return this;
        }

        public final void setNumberOfQueuedThings(Integer numberOfQueuedThings) {
            this.numberOfQueuedThings = numberOfQueuedThings;
        }

        public final Integer getNumberOfInProgressThings() {
            return this.numberOfInProgressThings;
        }

        @Override
        public final Builder numberOfInProgressThings(Integer numberOfInProgressThings) {
            this.numberOfInProgressThings = numberOfInProgressThings;
            return this;
        }

        public final void setNumberOfInProgressThings(Integer numberOfInProgressThings) {
            this.numberOfInProgressThings = numberOfInProgressThings;
        }

        public final Integer getNumberOfRemovedThings() {
            return this.numberOfRemovedThings;
        }

        @Override
        public final Builder numberOfRemovedThings(Integer numberOfRemovedThings) {
            this.numberOfRemovedThings = numberOfRemovedThings;
            return this;
        }

        public final void setNumberOfRemovedThings(Integer numberOfRemovedThings) {
            this.numberOfRemovedThings = numberOfRemovedThings;
        }

        public JobProcessDetails build() {
            return new JobProcessDetails(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, JobProcessDetails> {
        public Builder processingTargets(Collection<String> var1);

        public Builder processingTargets(String ... var1);

        public Builder numberOfCanceledThings(Integer var1);

        public Builder numberOfSucceededThings(Integer var1);

        public Builder numberOfFailedThings(Integer var1);

        public Builder numberOfRejectedThings(Integer var1);

        public Builder numberOfQueuedThings(Integer var1);

        public Builder numberOfInProgressThings(Integer var1);

        public Builder numberOfRemovedThings(Integer var1);
    }
}

