/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.iot.model.AuthorizerSummary;
import software.amazon.awssdk.services.iot.model.AuthorizersCopier;
import software.amazon.awssdk.services.iot.model.IotResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListAuthorizersResponse
extends IotResponse
implements ToCopyableBuilder<Builder, ListAuthorizersResponse> {
    private final List<AuthorizerSummary> authorizers;
    private final String nextMarker;

    private ListAuthorizersResponse(BuilderImpl builder) {
        super(builder);
        this.authorizers = builder.authorizers;
        this.nextMarker = builder.nextMarker;
    }

    public List<AuthorizerSummary> authorizers() {
        return this.authorizers;
    }

    public String nextMarker() {
        return this.nextMarker;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.authorizers());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextMarker());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListAuthorizersResponse)) {
            return false;
        }
        ListAuthorizersResponse other = (ListAuthorizersResponse)((Object)obj);
        return Objects.equals(this.authorizers(), other.authorizers()) && Objects.equals(this.nextMarker(), other.nextMarker());
    }

    public String toString() {
        return ToString.builder((String)"ListAuthorizersResponse").add("Authorizers", this.authorizers()).add("NextMarker", (Object)this.nextMarker()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "authorizers": {
                return Optional.ofNullable(clazz.cast(this.authorizers()));
            }
            case "nextMarker": {
                return Optional.ofNullable(clazz.cast(this.nextMarker()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends IotResponse.BuilderImpl
    implements Builder {
        private List<AuthorizerSummary> authorizers = DefaultSdkAutoConstructList.getInstance();
        private String nextMarker;

        private BuilderImpl() {
        }

        private BuilderImpl(ListAuthorizersResponse model) {
            super(model);
            this.authorizers(model.authorizers);
            this.nextMarker(model.nextMarker);
        }

        public final Collection<AuthorizerSummary.Builder> getAuthorizers() {
            return this.authorizers != null ? (Collection)this.authorizers.stream().map(AuthorizerSummary::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder authorizers(Collection<AuthorizerSummary> authorizers) {
            this.authorizers = AuthorizersCopier.copy(authorizers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder authorizers(AuthorizerSummary ... authorizers) {
            this.authorizers(Arrays.asList(authorizers));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder authorizers(Consumer<AuthorizerSummary.Builder> ... authorizers) {
            this.authorizers(Stream.of(authorizers).map(c -> (AuthorizerSummary)((AuthorizerSummary.Builder)AuthorizerSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setAuthorizers(Collection<AuthorizerSummary.BuilderImpl> authorizers) {
            this.authorizers = AuthorizersCopier.copyFromBuilder(authorizers);
        }

        public final String getNextMarker() {
            return this.nextMarker;
        }

        @Override
        public final Builder nextMarker(String nextMarker) {
            this.nextMarker = nextMarker;
            return this;
        }

        public final void setNextMarker(String nextMarker) {
            this.nextMarker = nextMarker;
        }

        @Override
        public ListAuthorizersResponse build() {
            return new ListAuthorizersResponse(this);
        }
    }

    public static interface Builder
    extends IotResponse.Builder,
    CopyableBuilder<Builder, ListAuthorizersResponse> {
        public Builder authorizers(Collection<AuthorizerSummary> var1);

        public Builder authorizers(AuthorizerSummary ... var1);

        public Builder authorizers(Consumer<AuthorizerSummary.Builder> ... var1);

        public Builder nextMarker(String var1);
    }
}

