/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.iot.model.IotResponse;
import software.amazon.awssdk.services.iot.model.StreamSummary;
import software.amazon.awssdk.services.iot.model.StreamsSummaryCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListStreamsResponse
extends IotResponse
implements ToCopyableBuilder<Builder, ListStreamsResponse> {
    private final List<StreamSummary> streams;
    private final String nextToken;

    private ListStreamsResponse(BuilderImpl builder) {
        super(builder);
        this.streams = builder.streams;
        this.nextToken = builder.nextToken;
    }

    public List<StreamSummary> streams() {
        return this.streams;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.streams());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListStreamsResponse)) {
            return false;
        }
        ListStreamsResponse other = (ListStreamsResponse)((Object)obj);
        return Objects.equals(this.streams(), other.streams()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"ListStreamsResponse").add("Streams", this.streams()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "streams": {
                return Optional.ofNullable(clazz.cast(this.streams()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends IotResponse.BuilderImpl
    implements Builder {
        private List<StreamSummary> streams = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListStreamsResponse model) {
            super(model);
            this.streams(model.streams);
            this.nextToken(model.nextToken);
        }

        public final Collection<StreamSummary.Builder> getStreams() {
            return this.streams != null ? (Collection)this.streams.stream().map(StreamSummary::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder streams(Collection<StreamSummary> streams) {
            this.streams = StreamsSummaryCopier.copy(streams);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder streams(StreamSummary ... streams) {
            this.streams(Arrays.asList(streams));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder streams(Consumer<StreamSummary.Builder> ... streams) {
            this.streams(Stream.of(streams).map(c -> (StreamSummary)((StreamSummary.Builder)StreamSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setStreams(Collection<StreamSummary.BuilderImpl> streams) {
            this.streams = StreamsSummaryCopier.copyFromBuilder(streams);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListStreamsResponse build() {
            return new ListStreamsResponse(this);
        }
    }

    public static interface Builder
    extends IotResponse.Builder,
    CopyableBuilder<Builder, ListStreamsResponse> {
        public Builder streams(Collection<StreamSummary> var1);

        public Builder streams(StreamSummary ... var1);

        public Builder streams(Consumer<StreamSummary.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

