/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.iot.model.GroupNameAndArn;
import software.amazon.awssdk.services.iot.model.IotResponse;
import software.amazon.awssdk.services.iot.model.ThingGroupNameAndArnListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListThingGroupsForThingResponse
extends IotResponse
implements ToCopyableBuilder<Builder, ListThingGroupsForThingResponse> {
    private final List<GroupNameAndArn> thingGroups;
    private final String nextToken;

    private ListThingGroupsForThingResponse(BuilderImpl builder) {
        super(builder);
        this.thingGroups = builder.thingGroups;
        this.nextToken = builder.nextToken;
    }

    public List<GroupNameAndArn> thingGroups() {
        return this.thingGroups;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.thingGroups());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListThingGroupsForThingResponse)) {
            return false;
        }
        ListThingGroupsForThingResponse other = (ListThingGroupsForThingResponse)((Object)obj);
        return Objects.equals(this.thingGroups(), other.thingGroups()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"ListThingGroupsForThingResponse").add("ThingGroups", this.thingGroups()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "thingGroups": {
                return Optional.ofNullable(clazz.cast(this.thingGroups()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends IotResponse.BuilderImpl
    implements Builder {
        private List<GroupNameAndArn> thingGroups = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListThingGroupsForThingResponse model) {
            super(model);
            this.thingGroups(model.thingGroups);
            this.nextToken(model.nextToken);
        }

        public final Collection<GroupNameAndArn.Builder> getThingGroups() {
            return this.thingGroups != null ? (Collection)this.thingGroups.stream().map(GroupNameAndArn::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder thingGroups(Collection<GroupNameAndArn> thingGroups) {
            this.thingGroups = ThingGroupNameAndArnListCopier.copy(thingGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder thingGroups(GroupNameAndArn ... thingGroups) {
            this.thingGroups(Arrays.asList(thingGroups));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder thingGroups(Consumer<GroupNameAndArn.Builder> ... thingGroups) {
            this.thingGroups(Stream.of(thingGroups).map(c -> (GroupNameAndArn)((GroupNameAndArn.Builder)GroupNameAndArn.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setThingGroups(Collection<GroupNameAndArn.BuilderImpl> thingGroups) {
            this.thingGroups = ThingGroupNameAndArnListCopier.copyFromBuilder(thingGroups);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListThingGroupsForThingResponse build() {
            return new ListThingGroupsForThingResponse(this);
        }
    }

    public static interface Builder
    extends IotResponse.Builder,
    CopyableBuilder<Builder, ListThingGroupsForThingResponse> {
        public Builder thingGroups(Collection<GroupNameAndArn> var1);

        public Builder thingGroups(GroupNameAndArn ... var1);

        public Builder thingGroups(Consumer<GroupNameAndArn.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

