/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.services.iot.model.IotRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListThingGroupsRequest
extends IotRequest
implements ToCopyableBuilder<Builder, ListThingGroupsRequest> {
    private final String nextToken;
    private final Integer maxResults;
    private final String parentGroup;
    private final String namePrefixFilter;
    private final Boolean recursive;

    private ListThingGroupsRequest(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
        this.parentGroup = builder.parentGroup;
        this.namePrefixFilter = builder.namePrefixFilter;
        this.recursive = builder.recursive;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Integer maxResults() {
        return this.maxResults;
    }

    public String parentGroup() {
        return this.parentGroup;
    }

    public String namePrefixFilter() {
        return this.namePrefixFilter;
    }

    public Boolean recursive() {
        return this.recursive;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.parentGroup());
        hashCode = 31 * hashCode + Objects.hashCode(this.namePrefixFilter());
        hashCode = 31 * hashCode + Objects.hashCode(this.recursive());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListThingGroupsRequest)) {
            return false;
        }
        ListThingGroupsRequest other = (ListThingGroupsRequest)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.parentGroup(), other.parentGroup()) && Objects.equals(this.namePrefixFilter(), other.namePrefixFilter()) && Objects.equals(this.recursive(), other.recursive());
    }

    public String toString() {
        return ToString.builder((String)"ListThingGroupsRequest").add("NextToken", (Object)this.nextToken()).add("MaxResults", (Object)this.maxResults()).add("ParentGroup", (Object)this.parentGroup()).add("NamePrefixFilter", (Object)this.namePrefixFilter()).add("Recursive", (Object)this.recursive()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "maxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "parentGroup": {
                return Optional.ofNullable(clazz.cast(this.parentGroup()));
            }
            case "namePrefixFilter": {
                return Optional.ofNullable(clazz.cast(this.namePrefixFilter()));
            }
            case "recursive": {
                return Optional.ofNullable(clazz.cast(this.recursive()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends IotRequest.BuilderImpl
    implements Builder {
        private String nextToken;
        private Integer maxResults;
        private String parentGroup;
        private String namePrefixFilter;
        private Boolean recursive;

        private BuilderImpl() {
        }

        private BuilderImpl(ListThingGroupsRequest model) {
            super(model);
            this.nextToken(model.nextToken);
            this.maxResults(model.maxResults);
            this.parentGroup(model.parentGroup);
            this.namePrefixFilter(model.namePrefixFilter);
            this.recursive(model.recursive);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        public final String getParentGroup() {
            return this.parentGroup;
        }

        @Override
        public final Builder parentGroup(String parentGroup) {
            this.parentGroup = parentGroup;
            return this;
        }

        public final void setParentGroup(String parentGroup) {
            this.parentGroup = parentGroup;
        }

        public final String getNamePrefixFilter() {
            return this.namePrefixFilter;
        }

        @Override
        public final Builder namePrefixFilter(String namePrefixFilter) {
            this.namePrefixFilter = namePrefixFilter;
            return this;
        }

        public final void setNamePrefixFilter(String namePrefixFilter) {
            this.namePrefixFilter = namePrefixFilter;
        }

        public final Boolean getRecursive() {
            return this.recursive;
        }

        @Override
        public final Builder recursive(Boolean recursive) {
            this.recursive = recursive;
            return this;
        }

        public final void setRecursive(Boolean recursive) {
            this.recursive = recursive;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListThingGroupsRequest build() {
            return new ListThingGroupsRequest(this);
        }
    }

    public static interface Builder
    extends IotRequest.Builder,
    CopyableBuilder<Builder, ListThingGroupsRequest> {
        public Builder nextToken(String var1);

        public Builder maxResults(Integer var1);

        public Builder parentGroup(String var1);

        public Builder namePrefixFilter(String var1);

        public Builder recursive(Boolean var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

