/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.iot.model.IotResponse;
import software.amazon.awssdk.services.iot.model.TaskIdListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListThingRegistrationTasksResponse
extends IotResponse
implements ToCopyableBuilder<Builder, ListThingRegistrationTasksResponse> {
    private final List<String> taskIds;
    private final String nextToken;

    private ListThingRegistrationTasksResponse(BuilderImpl builder) {
        super(builder);
        this.taskIds = builder.taskIds;
        this.nextToken = builder.nextToken;
    }

    public List<String> taskIds() {
        return this.taskIds;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.taskIds());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListThingRegistrationTasksResponse)) {
            return false;
        }
        ListThingRegistrationTasksResponse other = (ListThingRegistrationTasksResponse)((Object)obj);
        return Objects.equals(this.taskIds(), other.taskIds()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"ListThingRegistrationTasksResponse").add("TaskIds", this.taskIds()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "taskIds": {
                return Optional.ofNullable(clazz.cast(this.taskIds()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends IotResponse.BuilderImpl
    implements Builder {
        private List<String> taskIds = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListThingRegistrationTasksResponse model) {
            super(model);
            this.taskIds(model.taskIds);
            this.nextToken(model.nextToken);
        }

        public final Collection<String> getTaskIds() {
            return this.taskIds;
        }

        @Override
        public final Builder taskIds(Collection<String> taskIds) {
            this.taskIds = TaskIdListCopier.copy(taskIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder taskIds(String ... taskIds) {
            this.taskIds(Arrays.asList(taskIds));
            return this;
        }

        public final void setTaskIds(Collection<String> taskIds) {
            this.taskIds = TaskIdListCopier.copy(taskIds);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListThingRegistrationTasksResponse build() {
            return new ListThingRegistrationTasksResponse(this);
        }
    }

    public static interface Builder
    extends IotResponse.Builder,
    CopyableBuilder<Builder, ListThingRegistrationTasksResponse> {
        public Builder taskIds(Collection<String> var1);

        public Builder taskIds(String ... var1);

        public Builder nextToken(String var1);
    }
}

