/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.services.iot.model.AdditionalParameterMapCopier;
import software.amazon.awssdk.services.iot.model.AwsJobExecutionsRolloutConfig;
import software.amazon.awssdk.services.iot.model.ErrorInfo;
import software.amazon.awssdk.services.iot.model.OTAUpdateFile;
import software.amazon.awssdk.services.iot.model.OTAUpdateFilesCopier;
import software.amazon.awssdk.services.iot.model.OTAUpdateStatus;
import software.amazon.awssdk.services.iot.model.TargetSelection;
import software.amazon.awssdk.services.iot.model.TargetsCopier;
import software.amazon.awssdk.services.iot.transform.OTAUpdateInfoMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class OTAUpdateInfo
implements StructuredPojo,
ToCopyableBuilder<Builder, OTAUpdateInfo> {
    private final String otaUpdateId;
    private final String otaUpdateArn;
    private final Instant creationDate;
    private final Instant lastModifiedDate;
    private final String description;
    private final List<String> targets;
    private final AwsJobExecutionsRolloutConfig awsJobExecutionsRolloutConfig;
    private final String targetSelection;
    private final List<OTAUpdateFile> otaUpdateFiles;
    private final String otaUpdateStatus;
    private final String awsIotJobId;
    private final String awsIotJobArn;
    private final ErrorInfo errorInfo;
    private final Map<String, String> additionalParameters;

    private OTAUpdateInfo(BuilderImpl builder) {
        this.otaUpdateId = builder.otaUpdateId;
        this.otaUpdateArn = builder.otaUpdateArn;
        this.creationDate = builder.creationDate;
        this.lastModifiedDate = builder.lastModifiedDate;
        this.description = builder.description;
        this.targets = builder.targets;
        this.awsJobExecutionsRolloutConfig = builder.awsJobExecutionsRolloutConfig;
        this.targetSelection = builder.targetSelection;
        this.otaUpdateFiles = builder.otaUpdateFiles;
        this.otaUpdateStatus = builder.otaUpdateStatus;
        this.awsIotJobId = builder.awsIotJobId;
        this.awsIotJobArn = builder.awsIotJobArn;
        this.errorInfo = builder.errorInfo;
        this.additionalParameters = builder.additionalParameters;
    }

    public String otaUpdateId() {
        return this.otaUpdateId;
    }

    public String otaUpdateArn() {
        return this.otaUpdateArn;
    }

    public Instant creationDate() {
        return this.creationDate;
    }

    public Instant lastModifiedDate() {
        return this.lastModifiedDate;
    }

    public String description() {
        return this.description;
    }

    public List<String> targets() {
        return this.targets;
    }

    public AwsJobExecutionsRolloutConfig awsJobExecutionsRolloutConfig() {
        return this.awsJobExecutionsRolloutConfig;
    }

    public TargetSelection targetSelection() {
        return TargetSelection.fromValue(this.targetSelection);
    }

    public String targetSelectionAsString() {
        return this.targetSelection;
    }

    public List<OTAUpdateFile> otaUpdateFiles() {
        return this.otaUpdateFiles;
    }

    public OTAUpdateStatus otaUpdateStatus() {
        return OTAUpdateStatus.fromValue(this.otaUpdateStatus);
    }

    public String otaUpdateStatusAsString() {
        return this.otaUpdateStatus;
    }

    public String awsIotJobId() {
        return this.awsIotJobId;
    }

    public String awsIotJobArn() {
        return this.awsIotJobArn;
    }

    public ErrorInfo errorInfo() {
        return this.errorInfo;
    }

    public Map<String, String> additionalParameters() {
        return this.additionalParameters;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.otaUpdateId());
        hashCode = 31 * hashCode + Objects.hashCode(this.otaUpdateArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModifiedDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.targets());
        hashCode = 31 * hashCode + Objects.hashCode(this.awsJobExecutionsRolloutConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetSelectionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.otaUpdateFiles());
        hashCode = 31 * hashCode + Objects.hashCode(this.otaUpdateStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.awsIotJobId());
        hashCode = 31 * hashCode + Objects.hashCode(this.awsIotJobArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.errorInfo());
        hashCode = 31 * hashCode + Objects.hashCode(this.additionalParameters());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OTAUpdateInfo)) {
            return false;
        }
        OTAUpdateInfo other = (OTAUpdateInfo)obj;
        return Objects.equals(this.otaUpdateId(), other.otaUpdateId()) && Objects.equals(this.otaUpdateArn(), other.otaUpdateArn()) && Objects.equals(this.creationDate(), other.creationDate()) && Objects.equals(this.lastModifiedDate(), other.lastModifiedDate()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.targets(), other.targets()) && Objects.equals(this.awsJobExecutionsRolloutConfig(), other.awsJobExecutionsRolloutConfig()) && Objects.equals(this.targetSelectionAsString(), other.targetSelectionAsString()) && Objects.equals(this.otaUpdateFiles(), other.otaUpdateFiles()) && Objects.equals(this.otaUpdateStatusAsString(), other.otaUpdateStatusAsString()) && Objects.equals(this.awsIotJobId(), other.awsIotJobId()) && Objects.equals(this.awsIotJobArn(), other.awsIotJobArn()) && Objects.equals(this.errorInfo(), other.errorInfo()) && Objects.equals(this.additionalParameters(), other.additionalParameters());
    }

    public String toString() {
        return ToString.builder((String)"OTAUpdateInfo").add("OtaUpdateId", (Object)this.otaUpdateId()).add("OtaUpdateArn", (Object)this.otaUpdateArn()).add("CreationDate", (Object)this.creationDate()).add("LastModifiedDate", (Object)this.lastModifiedDate()).add("Description", (Object)this.description()).add("Targets", this.targets()).add("AwsJobExecutionsRolloutConfig", (Object)this.awsJobExecutionsRolloutConfig()).add("TargetSelection", (Object)this.targetSelectionAsString()).add("OtaUpdateFiles", this.otaUpdateFiles()).add("OtaUpdateStatus", (Object)this.otaUpdateStatusAsString()).add("AwsIotJobId", (Object)this.awsIotJobId()).add("AwsIotJobArn", (Object)this.awsIotJobArn()).add("ErrorInfo", (Object)this.errorInfo()).add("AdditionalParameters", this.additionalParameters()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "otaUpdateId": {
                return Optional.ofNullable(clazz.cast(this.otaUpdateId()));
            }
            case "otaUpdateArn": {
                return Optional.ofNullable(clazz.cast(this.otaUpdateArn()));
            }
            case "creationDate": {
                return Optional.ofNullable(clazz.cast(this.creationDate()));
            }
            case "lastModifiedDate": {
                return Optional.ofNullable(clazz.cast(this.lastModifiedDate()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "targets": {
                return Optional.ofNullable(clazz.cast(this.targets()));
            }
            case "awsJobExecutionsRolloutConfig": {
                return Optional.ofNullable(clazz.cast(this.awsJobExecutionsRolloutConfig()));
            }
            case "targetSelection": {
                return Optional.ofNullable(clazz.cast(this.targetSelectionAsString()));
            }
            case "otaUpdateFiles": {
                return Optional.ofNullable(clazz.cast(this.otaUpdateFiles()));
            }
            case "otaUpdateStatus": {
                return Optional.ofNullable(clazz.cast(this.otaUpdateStatusAsString()));
            }
            case "awsIotJobId": {
                return Optional.ofNullable(clazz.cast(this.awsIotJobId()));
            }
            case "awsIotJobArn": {
                return Optional.ofNullable(clazz.cast(this.awsIotJobArn()));
            }
            case "errorInfo": {
                return Optional.ofNullable(clazz.cast(this.errorInfo()));
            }
            case "additionalParameters": {
                return Optional.ofNullable(clazz.cast(this.additionalParameters()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        OTAUpdateInfoMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String otaUpdateId;
        private String otaUpdateArn;
        private Instant creationDate;
        private Instant lastModifiedDate;
        private String description;
        private List<String> targets = DefaultSdkAutoConstructList.getInstance();
        private AwsJobExecutionsRolloutConfig awsJobExecutionsRolloutConfig;
        private String targetSelection;
        private List<OTAUpdateFile> otaUpdateFiles = DefaultSdkAutoConstructList.getInstance();
        private String otaUpdateStatus;
        private String awsIotJobId;
        private String awsIotJobArn;
        private ErrorInfo errorInfo;
        private Map<String, String> additionalParameters = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(OTAUpdateInfo model) {
            this.otaUpdateId(model.otaUpdateId);
            this.otaUpdateArn(model.otaUpdateArn);
            this.creationDate(model.creationDate);
            this.lastModifiedDate(model.lastModifiedDate);
            this.description(model.description);
            this.targets(model.targets);
            this.awsJobExecutionsRolloutConfig(model.awsJobExecutionsRolloutConfig);
            this.targetSelection(model.targetSelection);
            this.otaUpdateFiles(model.otaUpdateFiles);
            this.otaUpdateStatus(model.otaUpdateStatus);
            this.awsIotJobId(model.awsIotJobId);
            this.awsIotJobArn(model.awsIotJobArn);
            this.errorInfo(model.errorInfo);
            this.additionalParameters(model.additionalParameters);
        }

        public final String getOtaUpdateId() {
            return this.otaUpdateId;
        }

        @Override
        public final Builder otaUpdateId(String otaUpdateId) {
            this.otaUpdateId = otaUpdateId;
            return this;
        }

        public final void setOtaUpdateId(String otaUpdateId) {
            this.otaUpdateId = otaUpdateId;
        }

        public final String getOtaUpdateArn() {
            return this.otaUpdateArn;
        }

        @Override
        public final Builder otaUpdateArn(String otaUpdateArn) {
            this.otaUpdateArn = otaUpdateArn;
            return this;
        }

        public final void setOtaUpdateArn(String otaUpdateArn) {
            this.otaUpdateArn = otaUpdateArn;
        }

        public final Instant getCreationDate() {
            return this.creationDate;
        }

        @Override
        public final Builder creationDate(Instant creationDate) {
            this.creationDate = creationDate;
            return this;
        }

        public final void setCreationDate(Instant creationDate) {
            this.creationDate = creationDate;
        }

        public final Instant getLastModifiedDate() {
            return this.lastModifiedDate;
        }

        @Override
        public final Builder lastModifiedDate(Instant lastModifiedDate) {
            this.lastModifiedDate = lastModifiedDate;
            return this;
        }

        public final void setLastModifiedDate(Instant lastModifiedDate) {
            this.lastModifiedDate = lastModifiedDate;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final Collection<String> getTargets() {
            return this.targets;
        }

        @Override
        public final Builder targets(Collection<String> targets) {
            this.targets = TargetsCopier.copy(targets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targets(String ... targets) {
            this.targets(Arrays.asList(targets));
            return this;
        }

        public final void setTargets(Collection<String> targets) {
            this.targets = TargetsCopier.copy(targets);
        }

        public final AwsJobExecutionsRolloutConfig.Builder getAwsJobExecutionsRolloutConfig() {
            return this.awsJobExecutionsRolloutConfig != null ? this.awsJobExecutionsRolloutConfig.toBuilder() : null;
        }

        @Override
        public final Builder awsJobExecutionsRolloutConfig(AwsJobExecutionsRolloutConfig awsJobExecutionsRolloutConfig) {
            this.awsJobExecutionsRolloutConfig = awsJobExecutionsRolloutConfig;
            return this;
        }

        public final void setAwsJobExecutionsRolloutConfig(AwsJobExecutionsRolloutConfig.BuilderImpl awsJobExecutionsRolloutConfig) {
            this.awsJobExecutionsRolloutConfig = awsJobExecutionsRolloutConfig != null ? awsJobExecutionsRolloutConfig.build() : null;
        }

        public final String getTargetSelection() {
            return this.targetSelection;
        }

        @Override
        public final Builder targetSelection(String targetSelection) {
            this.targetSelection = targetSelection;
            return this;
        }

        @Override
        public final Builder targetSelection(TargetSelection targetSelection) {
            this.targetSelection(targetSelection.toString());
            return this;
        }

        public final void setTargetSelection(String targetSelection) {
            this.targetSelection = targetSelection;
        }

        public final Collection<OTAUpdateFile.Builder> getOtaUpdateFiles() {
            return this.otaUpdateFiles != null ? (Collection)this.otaUpdateFiles.stream().map(OTAUpdateFile::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder otaUpdateFiles(Collection<OTAUpdateFile> otaUpdateFiles) {
            this.otaUpdateFiles = OTAUpdateFilesCopier.copy(otaUpdateFiles);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder otaUpdateFiles(OTAUpdateFile ... otaUpdateFiles) {
            this.otaUpdateFiles(Arrays.asList(otaUpdateFiles));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder otaUpdateFiles(Consumer<OTAUpdateFile.Builder> ... otaUpdateFiles) {
            this.otaUpdateFiles(Stream.of(otaUpdateFiles).map(c -> (OTAUpdateFile)((OTAUpdateFile.Builder)OTAUpdateFile.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setOtaUpdateFiles(Collection<OTAUpdateFile.BuilderImpl> otaUpdateFiles) {
            this.otaUpdateFiles = OTAUpdateFilesCopier.copyFromBuilder(otaUpdateFiles);
        }

        public final String getOtaUpdateStatus() {
            return this.otaUpdateStatus;
        }

        @Override
        public final Builder otaUpdateStatus(String otaUpdateStatus) {
            this.otaUpdateStatus = otaUpdateStatus;
            return this;
        }

        @Override
        public final Builder otaUpdateStatus(OTAUpdateStatus otaUpdateStatus) {
            this.otaUpdateStatus(otaUpdateStatus.toString());
            return this;
        }

        public final void setOtaUpdateStatus(String otaUpdateStatus) {
            this.otaUpdateStatus = otaUpdateStatus;
        }

        public final String getAwsIotJobId() {
            return this.awsIotJobId;
        }

        @Override
        public final Builder awsIotJobId(String awsIotJobId) {
            this.awsIotJobId = awsIotJobId;
            return this;
        }

        public final void setAwsIotJobId(String awsIotJobId) {
            this.awsIotJobId = awsIotJobId;
        }

        public final String getAwsIotJobArn() {
            return this.awsIotJobArn;
        }

        @Override
        public final Builder awsIotJobArn(String awsIotJobArn) {
            this.awsIotJobArn = awsIotJobArn;
            return this;
        }

        public final void setAwsIotJobArn(String awsIotJobArn) {
            this.awsIotJobArn = awsIotJobArn;
        }

        public final ErrorInfo.Builder getErrorInfo() {
            return this.errorInfo != null ? this.errorInfo.toBuilder() : null;
        }

        @Override
        public final Builder errorInfo(ErrorInfo errorInfo) {
            this.errorInfo = errorInfo;
            return this;
        }

        public final void setErrorInfo(ErrorInfo.BuilderImpl errorInfo) {
            this.errorInfo = errorInfo != null ? errorInfo.build() : null;
        }

        public final Map<String, String> getAdditionalParameters() {
            return this.additionalParameters;
        }

        @Override
        public final Builder additionalParameters(Map<String, String> additionalParameters) {
            this.additionalParameters = AdditionalParameterMapCopier.copy(additionalParameters);
            return this;
        }

        public final void setAdditionalParameters(Map<String, String> additionalParameters) {
            this.additionalParameters = AdditionalParameterMapCopier.copy(additionalParameters);
        }

        public OTAUpdateInfo build() {
            return new OTAUpdateInfo(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, OTAUpdateInfo> {
        public Builder otaUpdateId(String var1);

        public Builder otaUpdateArn(String var1);

        public Builder creationDate(Instant var1);

        public Builder lastModifiedDate(Instant var1);

        public Builder description(String var1);

        public Builder targets(Collection<String> var1);

        public Builder targets(String ... var1);

        public Builder awsJobExecutionsRolloutConfig(AwsJobExecutionsRolloutConfig var1);

        default public Builder awsJobExecutionsRolloutConfig(Consumer<AwsJobExecutionsRolloutConfig.Builder> awsJobExecutionsRolloutConfig) {
            return this.awsJobExecutionsRolloutConfig((AwsJobExecutionsRolloutConfig)((AwsJobExecutionsRolloutConfig.Builder)AwsJobExecutionsRolloutConfig.builder().applyMutation(awsJobExecutionsRolloutConfig)).build());
        }

        public Builder targetSelection(String var1);

        public Builder targetSelection(TargetSelection var1);

        public Builder otaUpdateFiles(Collection<OTAUpdateFile> var1);

        public Builder otaUpdateFiles(OTAUpdateFile ... var1);

        public Builder otaUpdateFiles(Consumer<OTAUpdateFile.Builder> ... var1);

        public Builder otaUpdateStatus(String var1);

        public Builder otaUpdateStatus(OTAUpdateStatus var1);

        public Builder awsIotJobId(String var1);

        public Builder awsIotJobArn(String var1);

        public Builder errorInfo(ErrorInfo var1);

        default public Builder errorInfo(Consumer<ErrorInfo.Builder> errorInfo) {
            return this.errorInfo((ErrorInfo)((ErrorInfo.Builder)ErrorInfo.builder().applyMutation(errorInfo)).build());
        }

        public Builder additionalParameters(Map<String, String> var1);
    }
}

