/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.iot.transform.PresignedUrlConfigMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PresignedUrlConfig
implements StructuredPojo,
ToCopyableBuilder<Builder, PresignedUrlConfig> {
    private final String roleArn;
    private final Long expiresInSec;

    private PresignedUrlConfig(BuilderImpl builder) {
        this.roleArn = builder.roleArn;
        this.expiresInSec = builder.expiresInSec;
    }

    public String roleArn() {
        return this.roleArn;
    }

    public Long expiresInSec() {
        return this.expiresInSec;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.expiresInSec());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PresignedUrlConfig)) {
            return false;
        }
        PresignedUrlConfig other = (PresignedUrlConfig)obj;
        return Objects.equals(this.roleArn(), other.roleArn()) && Objects.equals(this.expiresInSec(), other.expiresInSec());
    }

    public String toString() {
        return ToString.builder((String)"PresignedUrlConfig").add("RoleArn", (Object)this.roleArn()).add("ExpiresInSec", (Object)this.expiresInSec()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "roleArn": {
                return Optional.ofNullable(clazz.cast(this.roleArn()));
            }
            case "expiresInSec": {
                return Optional.ofNullable(clazz.cast(this.expiresInSec()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        PresignedUrlConfigMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String roleArn;
        private Long expiresInSec;

        private BuilderImpl() {
        }

        private BuilderImpl(PresignedUrlConfig model) {
            this.roleArn(model.roleArn);
            this.expiresInSec(model.expiresInSec);
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        public final Long getExpiresInSec() {
            return this.expiresInSec;
        }

        @Override
        public final Builder expiresInSec(Long expiresInSec) {
            this.expiresInSec = expiresInSec;
            return this;
        }

        public final void setExpiresInSec(Long expiresInSec) {
            this.expiresInSec = expiresInSec;
        }

        public PresignedUrlConfig build() {
            return new PresignedUrlConfig(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, PresignedUrlConfig> {
        public Builder roleArn(String var1);

        public Builder expiresInSec(Long var1);
    }
}

