/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.services.iot.model.IotRequest;
import software.amazon.awssdk.services.iot.model.RegistrationConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RegisterCaCertificateRequest
extends IotRequest
implements ToCopyableBuilder<Builder, RegisterCaCertificateRequest> {
    private final String caCertificate;
    private final String verificationCertificate;
    private final Boolean setAsActive;
    private final Boolean allowAutoRegistration;
    private final RegistrationConfig registrationConfig;

    private RegisterCaCertificateRequest(BuilderImpl builder) {
        super(builder);
        this.caCertificate = builder.caCertificate;
        this.verificationCertificate = builder.verificationCertificate;
        this.setAsActive = builder.setAsActive;
        this.allowAutoRegistration = builder.allowAutoRegistration;
        this.registrationConfig = builder.registrationConfig;
    }

    public String caCertificate() {
        return this.caCertificate;
    }

    public String verificationCertificate() {
        return this.verificationCertificate;
    }

    public Boolean setAsActive() {
        return this.setAsActive;
    }

    public Boolean allowAutoRegistration() {
        return this.allowAutoRegistration;
    }

    public RegistrationConfig registrationConfig() {
        return this.registrationConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.caCertificate());
        hashCode = 31 * hashCode + Objects.hashCode(this.verificationCertificate());
        hashCode = 31 * hashCode + Objects.hashCode(this.setAsActive());
        hashCode = 31 * hashCode + Objects.hashCode(this.allowAutoRegistration());
        hashCode = 31 * hashCode + Objects.hashCode(this.registrationConfig());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RegisterCaCertificateRequest)) {
            return false;
        }
        RegisterCaCertificateRequest other = (RegisterCaCertificateRequest)((Object)obj);
        return Objects.equals(this.caCertificate(), other.caCertificate()) && Objects.equals(this.verificationCertificate(), other.verificationCertificate()) && Objects.equals(this.setAsActive(), other.setAsActive()) && Objects.equals(this.allowAutoRegistration(), other.allowAutoRegistration()) && Objects.equals(this.registrationConfig(), other.registrationConfig());
    }

    public String toString() {
        return ToString.builder((String)"RegisterCaCertificateRequest").add("CaCertificate", (Object)this.caCertificate()).add("VerificationCertificate", (Object)this.verificationCertificate()).add("SetAsActive", (Object)this.setAsActive()).add("AllowAutoRegistration", (Object)this.allowAutoRegistration()).add("RegistrationConfig", (Object)this.registrationConfig()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "caCertificate": {
                return Optional.ofNullable(clazz.cast(this.caCertificate()));
            }
            case "verificationCertificate": {
                return Optional.ofNullable(clazz.cast(this.verificationCertificate()));
            }
            case "setAsActive": {
                return Optional.ofNullable(clazz.cast(this.setAsActive()));
            }
            case "allowAutoRegistration": {
                return Optional.ofNullable(clazz.cast(this.allowAutoRegistration()));
            }
            case "registrationConfig": {
                return Optional.ofNullable(clazz.cast(this.registrationConfig()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends IotRequest.BuilderImpl
    implements Builder {
        private String caCertificate;
        private String verificationCertificate;
        private Boolean setAsActive;
        private Boolean allowAutoRegistration;
        private RegistrationConfig registrationConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(RegisterCaCertificateRequest model) {
            super(model);
            this.caCertificate(model.caCertificate);
            this.verificationCertificate(model.verificationCertificate);
            this.setAsActive(model.setAsActive);
            this.allowAutoRegistration(model.allowAutoRegistration);
            this.registrationConfig(model.registrationConfig);
        }

        public final String getCaCertificate() {
            return this.caCertificate;
        }

        @Override
        public final Builder caCertificate(String caCertificate) {
            this.caCertificate = caCertificate;
            return this;
        }

        public final void setCaCertificate(String caCertificate) {
            this.caCertificate = caCertificate;
        }

        public final String getVerificationCertificate() {
            return this.verificationCertificate;
        }

        @Override
        public final Builder verificationCertificate(String verificationCertificate) {
            this.verificationCertificate = verificationCertificate;
            return this;
        }

        public final void setVerificationCertificate(String verificationCertificate) {
            this.verificationCertificate = verificationCertificate;
        }

        public final Boolean getSetAsActive() {
            return this.setAsActive;
        }

        @Override
        public final Builder setAsActive(Boolean setAsActive) {
            this.setAsActive = setAsActive;
            return this;
        }

        public final void setSetAsActive(Boolean setAsActive) {
            this.setAsActive = setAsActive;
        }

        public final Boolean getAllowAutoRegistration() {
            return this.allowAutoRegistration;
        }

        @Override
        public final Builder allowAutoRegistration(Boolean allowAutoRegistration) {
            this.allowAutoRegistration = allowAutoRegistration;
            return this;
        }

        public final void setAllowAutoRegistration(Boolean allowAutoRegistration) {
            this.allowAutoRegistration = allowAutoRegistration;
        }

        public final RegistrationConfig.Builder getRegistrationConfig() {
            return this.registrationConfig != null ? this.registrationConfig.toBuilder() : null;
        }

        @Override
        public final Builder registrationConfig(RegistrationConfig registrationConfig) {
            this.registrationConfig = registrationConfig;
            return this;
        }

        public final void setRegistrationConfig(RegistrationConfig.BuilderImpl registrationConfig) {
            this.registrationConfig = registrationConfig != null ? registrationConfig.build() : null;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public RegisterCaCertificateRequest build() {
            return new RegisterCaCertificateRequest(this);
        }
    }

    public static interface Builder
    extends IotRequest.Builder,
    CopyableBuilder<Builder, RegisterCaCertificateRequest> {
        public Builder caCertificate(String var1);

        public Builder verificationCertificate(String var1);

        public Builder setAsActive(Boolean var1);

        public Builder allowAutoRegistration(Boolean var1);

        public Builder registrationConfig(RegistrationConfig var1);

        default public Builder registrationConfig(Consumer<RegistrationConfig.Builder> registrationConfig) {
            return this.registrationConfig((RegistrationConfig)((RegistrationConfig.Builder)RegistrationConfig.builder().applyMutation(registrationConfig)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

