/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.iot.model.PolicyVersionIdentifier;
import software.amazon.awssdk.services.iot.transform.ResourceIdentifierMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ResourceIdentifier
implements StructuredPojo,
ToCopyableBuilder<Builder, ResourceIdentifier> {
    private final String deviceCertificateId;
    private final String caCertificateId;
    private final String cognitoIdentityPoolId;
    private final String clientId;
    private final PolicyVersionIdentifier policyVersionIdentifier;
    private final String account;

    private ResourceIdentifier(BuilderImpl builder) {
        this.deviceCertificateId = builder.deviceCertificateId;
        this.caCertificateId = builder.caCertificateId;
        this.cognitoIdentityPoolId = builder.cognitoIdentityPoolId;
        this.clientId = builder.clientId;
        this.policyVersionIdentifier = builder.policyVersionIdentifier;
        this.account = builder.account;
    }

    public String deviceCertificateId() {
        return this.deviceCertificateId;
    }

    public String caCertificateId() {
        return this.caCertificateId;
    }

    public String cognitoIdentityPoolId() {
        return this.cognitoIdentityPoolId;
    }

    public String clientId() {
        return this.clientId;
    }

    public PolicyVersionIdentifier policyVersionIdentifier() {
        return this.policyVersionIdentifier;
    }

    public String account() {
        return this.account;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.deviceCertificateId());
        hashCode = 31 * hashCode + Objects.hashCode(this.caCertificateId());
        hashCode = 31 * hashCode + Objects.hashCode(this.cognitoIdentityPoolId());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientId());
        hashCode = 31 * hashCode + Objects.hashCode(this.policyVersionIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.account());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResourceIdentifier)) {
            return false;
        }
        ResourceIdentifier other = (ResourceIdentifier)obj;
        return Objects.equals(this.deviceCertificateId(), other.deviceCertificateId()) && Objects.equals(this.caCertificateId(), other.caCertificateId()) && Objects.equals(this.cognitoIdentityPoolId(), other.cognitoIdentityPoolId()) && Objects.equals(this.clientId(), other.clientId()) && Objects.equals(this.policyVersionIdentifier(), other.policyVersionIdentifier()) && Objects.equals(this.account(), other.account());
    }

    public String toString() {
        return ToString.builder((String)"ResourceIdentifier").add("DeviceCertificateId", (Object)this.deviceCertificateId()).add("CaCertificateId", (Object)this.caCertificateId()).add("CognitoIdentityPoolId", (Object)this.cognitoIdentityPoolId()).add("ClientId", (Object)this.clientId()).add("PolicyVersionIdentifier", (Object)this.policyVersionIdentifier()).add("Account", (Object)this.account()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "deviceCertificateId": {
                return Optional.ofNullable(clazz.cast(this.deviceCertificateId()));
            }
            case "caCertificateId": {
                return Optional.ofNullable(clazz.cast(this.caCertificateId()));
            }
            case "cognitoIdentityPoolId": {
                return Optional.ofNullable(clazz.cast(this.cognitoIdentityPoolId()));
            }
            case "clientId": {
                return Optional.ofNullable(clazz.cast(this.clientId()));
            }
            case "policyVersionIdentifier": {
                return Optional.ofNullable(clazz.cast(this.policyVersionIdentifier()));
            }
            case "account": {
                return Optional.ofNullable(clazz.cast(this.account()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ResourceIdentifierMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String deviceCertificateId;
        private String caCertificateId;
        private String cognitoIdentityPoolId;
        private String clientId;
        private PolicyVersionIdentifier policyVersionIdentifier;
        private String account;

        private BuilderImpl() {
        }

        private BuilderImpl(ResourceIdentifier model) {
            this.deviceCertificateId(model.deviceCertificateId);
            this.caCertificateId(model.caCertificateId);
            this.cognitoIdentityPoolId(model.cognitoIdentityPoolId);
            this.clientId(model.clientId);
            this.policyVersionIdentifier(model.policyVersionIdentifier);
            this.account(model.account);
        }

        public final String getDeviceCertificateId() {
            return this.deviceCertificateId;
        }

        @Override
        public final Builder deviceCertificateId(String deviceCertificateId) {
            this.deviceCertificateId = deviceCertificateId;
            return this;
        }

        public final void setDeviceCertificateId(String deviceCertificateId) {
            this.deviceCertificateId = deviceCertificateId;
        }

        public final String getCaCertificateId() {
            return this.caCertificateId;
        }

        @Override
        public final Builder caCertificateId(String caCertificateId) {
            this.caCertificateId = caCertificateId;
            return this;
        }

        public final void setCaCertificateId(String caCertificateId) {
            this.caCertificateId = caCertificateId;
        }

        public final String getCognitoIdentityPoolId() {
            return this.cognitoIdentityPoolId;
        }

        @Override
        public final Builder cognitoIdentityPoolId(String cognitoIdentityPoolId) {
            this.cognitoIdentityPoolId = cognitoIdentityPoolId;
            return this;
        }

        public final void setCognitoIdentityPoolId(String cognitoIdentityPoolId) {
            this.cognitoIdentityPoolId = cognitoIdentityPoolId;
        }

        public final String getClientId() {
            return this.clientId;
        }

        @Override
        public final Builder clientId(String clientId) {
            this.clientId = clientId;
            return this;
        }

        public final void setClientId(String clientId) {
            this.clientId = clientId;
        }

        public final PolicyVersionIdentifier.Builder getPolicyVersionIdentifier() {
            return this.policyVersionIdentifier != null ? this.policyVersionIdentifier.toBuilder() : null;
        }

        @Override
        public final Builder policyVersionIdentifier(PolicyVersionIdentifier policyVersionIdentifier) {
            this.policyVersionIdentifier = policyVersionIdentifier;
            return this;
        }

        public final void setPolicyVersionIdentifier(PolicyVersionIdentifier.BuilderImpl policyVersionIdentifier) {
            this.policyVersionIdentifier = policyVersionIdentifier != null ? policyVersionIdentifier.build() : null;
        }

        public final String getAccount() {
            return this.account;
        }

        @Override
        public final Builder account(String account) {
            this.account = account;
            return this;
        }

        public final void setAccount(String account) {
            this.account = account;
        }

        public ResourceIdentifier build() {
            return new ResourceIdentifier(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ResourceIdentifier> {
        public Builder deviceCertificateId(String var1);

        public Builder caCertificateId(String var1);

        public Builder cognitoIdentityPoolId(String var1);

        public Builder clientId(String var1);

        public Builder policyVersionIdentifier(PolicyVersionIdentifier var1);

        default public Builder policyVersionIdentifier(Consumer<PolicyVersionIdentifier.Builder> policyVersionIdentifier) {
            return this.policyVersionIdentifier((PolicyVersionIdentifier)((PolicyVersionIdentifier.Builder)PolicyVersionIdentifier.builder().applyMutation(policyVersionIdentifier)).build());
        }

        public Builder account(String var1);
    }
}

