/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.services.iot.model.IotRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SearchIndexRequest
extends IotRequest
implements ToCopyableBuilder<Builder, SearchIndexRequest> {
    private final String indexName;
    private final String queryString;
    private final String nextToken;
    private final Integer maxResults;
    private final String queryVersion;

    private SearchIndexRequest(BuilderImpl builder) {
        super(builder);
        this.indexName = builder.indexName;
        this.queryString = builder.queryString;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
        this.queryVersion = builder.queryVersion;
    }

    public String indexName() {
        return this.indexName;
    }

    public String queryString() {
        return this.queryString;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Integer maxResults() {
        return this.maxResults;
    }

    public String queryVersion() {
        return this.queryVersion;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.indexName());
        hashCode = 31 * hashCode + Objects.hashCode(this.queryString());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.queryVersion());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SearchIndexRequest)) {
            return false;
        }
        SearchIndexRequest other = (SearchIndexRequest)((Object)obj);
        return Objects.equals(this.indexName(), other.indexName()) && Objects.equals(this.queryString(), other.queryString()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.queryVersion(), other.queryVersion());
    }

    public String toString() {
        return ToString.builder((String)"SearchIndexRequest").add("IndexName", (Object)this.indexName()).add("QueryString", (Object)this.queryString()).add("NextToken", (Object)this.nextToken()).add("MaxResults", (Object)this.maxResults()).add("QueryVersion", (Object)this.queryVersion()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "indexName": {
                return Optional.ofNullable(clazz.cast(this.indexName()));
            }
            case "queryString": {
                return Optional.ofNullable(clazz.cast(this.queryString()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "maxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "queryVersion": {
                return Optional.ofNullable(clazz.cast(this.queryVersion()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends IotRequest.BuilderImpl
    implements Builder {
        private String indexName;
        private String queryString;
        private String nextToken;
        private Integer maxResults;
        private String queryVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(SearchIndexRequest model) {
            super(model);
            this.indexName(model.indexName);
            this.queryString(model.queryString);
            this.nextToken(model.nextToken);
            this.maxResults(model.maxResults);
            this.queryVersion(model.queryVersion);
        }

        public final String getIndexName() {
            return this.indexName;
        }

        @Override
        public final Builder indexName(String indexName) {
            this.indexName = indexName;
            return this;
        }

        public final void setIndexName(String indexName) {
            this.indexName = indexName;
        }

        public final String getQueryString() {
            return this.queryString;
        }

        @Override
        public final Builder queryString(String queryString) {
            this.queryString = queryString;
            return this;
        }

        public final void setQueryString(String queryString) {
            this.queryString = queryString;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        public final String getQueryVersion() {
            return this.queryVersion;
        }

        @Override
        public final Builder queryVersion(String queryVersion) {
            this.queryVersion = queryVersion;
            return this;
        }

        public final void setQueryVersion(String queryVersion) {
            this.queryVersion = queryVersion;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public SearchIndexRequest build() {
            return new SearchIndexRequest(this);
        }
    }

    public static interface Builder
    extends IotRequest.Builder,
    CopyableBuilder<Builder, SearchIndexRequest> {
        public Builder indexName(String var1);

        public Builder queryString(String var1);

        public Builder nextToken(String var1);

        public Builder maxResults(Integer var1);

        public Builder queryVersion(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

