/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.services.iot.model.IotRequest;
import software.amazon.awssdk.services.iot.model.LogLevel;
import software.amazon.awssdk.services.iot.model.LogTarget;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SetV2LoggingLevelRequest
extends IotRequest
implements ToCopyableBuilder<Builder, SetV2LoggingLevelRequest> {
    private final LogTarget logTarget;
    private final String logLevel;

    private SetV2LoggingLevelRequest(BuilderImpl builder) {
        super(builder);
        this.logTarget = builder.logTarget;
        this.logLevel = builder.logLevel;
    }

    public LogTarget logTarget() {
        return this.logTarget;
    }

    public LogLevel logLevel() {
        return LogLevel.fromValue(this.logLevel);
    }

    public String logLevelAsString() {
        return this.logLevel;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.logTarget());
        hashCode = 31 * hashCode + Objects.hashCode(this.logLevelAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SetV2LoggingLevelRequest)) {
            return false;
        }
        SetV2LoggingLevelRequest other = (SetV2LoggingLevelRequest)((Object)obj);
        return Objects.equals(this.logTarget(), other.logTarget()) && Objects.equals(this.logLevelAsString(), other.logLevelAsString());
    }

    public String toString() {
        return ToString.builder((String)"SetV2LoggingLevelRequest").add("LogTarget", (Object)this.logTarget()).add("LogLevel", (Object)this.logLevelAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "logTarget": {
                return Optional.ofNullable(clazz.cast(this.logTarget()));
            }
            case "logLevel": {
                return Optional.ofNullable(clazz.cast(this.logLevelAsString()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends IotRequest.BuilderImpl
    implements Builder {
        private LogTarget logTarget;
        private String logLevel;

        private BuilderImpl() {
        }

        private BuilderImpl(SetV2LoggingLevelRequest model) {
            super(model);
            this.logTarget(model.logTarget);
            this.logLevel(model.logLevel);
        }

        public final LogTarget.Builder getLogTarget() {
            return this.logTarget != null ? this.logTarget.toBuilder() : null;
        }

        @Override
        public final Builder logTarget(LogTarget logTarget) {
            this.logTarget = logTarget;
            return this;
        }

        public final void setLogTarget(LogTarget.BuilderImpl logTarget) {
            this.logTarget = logTarget != null ? logTarget.build() : null;
        }

        public final String getLogLevel() {
            return this.logLevel;
        }

        @Override
        public final Builder logLevel(String logLevel) {
            this.logLevel = logLevel;
            return this;
        }

        @Override
        public final Builder logLevel(LogLevel logLevel) {
            this.logLevel(logLevel.toString());
            return this;
        }

        public final void setLogLevel(String logLevel) {
            this.logLevel = logLevel;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public SetV2LoggingLevelRequest build() {
            return new SetV2LoggingLevelRequest(this);
        }
    }

    public static interface Builder
    extends IotRequest.Builder,
    CopyableBuilder<Builder, SetV2LoggingLevelRequest> {
        public Builder logTarget(LogTarget var1);

        default public Builder logTarget(Consumer<LogTarget.Builder> logTarget) {
            return this.logTarget((LogTarget)((LogTarget.Builder)LogTarget.builder().applyMutation(logTarget)).build());
        }

        public Builder logLevel(String var1);

        public Builder logLevel(LogLevel var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

