/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.iot.model.IotRequest;
import software.amazon.awssdk.services.iot.model.TargetAuditCheckNamesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StartOnDemandAuditTaskRequest
extends IotRequest
implements ToCopyableBuilder<Builder, StartOnDemandAuditTaskRequest> {
    private final List<String> targetCheckNames;

    private StartOnDemandAuditTaskRequest(BuilderImpl builder) {
        super(builder);
        this.targetCheckNames = builder.targetCheckNames;
    }

    public List<String> targetCheckNames() {
        return this.targetCheckNames;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.targetCheckNames());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartOnDemandAuditTaskRequest)) {
            return false;
        }
        StartOnDemandAuditTaskRequest other = (StartOnDemandAuditTaskRequest)((Object)obj);
        return Objects.equals(this.targetCheckNames(), other.targetCheckNames());
    }

    public String toString() {
        return ToString.builder((String)"StartOnDemandAuditTaskRequest").add("TargetCheckNames", this.targetCheckNames()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "targetCheckNames": {
                return Optional.ofNullable(clazz.cast(this.targetCheckNames()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends IotRequest.BuilderImpl
    implements Builder {
        private List<String> targetCheckNames = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(StartOnDemandAuditTaskRequest model) {
            super(model);
            this.targetCheckNames(model.targetCheckNames);
        }

        public final Collection<String> getTargetCheckNames() {
            return this.targetCheckNames;
        }

        @Override
        public final Builder targetCheckNames(Collection<String> targetCheckNames) {
            this.targetCheckNames = TargetAuditCheckNamesCopier.copy(targetCheckNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targetCheckNames(String ... targetCheckNames) {
            this.targetCheckNames(Arrays.asList(targetCheckNames));
            return this;
        }

        public final void setTargetCheckNames(Collection<String> targetCheckNames) {
            this.targetCheckNames = TargetAuditCheckNamesCopier.copy(targetCheckNames);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartOnDemandAuditTaskRequest build() {
            return new StartOnDemandAuditTaskRequest(this);
        }
    }

    public static interface Builder
    extends IotRequest.Builder,
    CopyableBuilder<Builder, StartOnDemandAuditTaskRequest> {
        public Builder targetCheckNames(Collection<String> var1);

        public Builder targetCheckNames(String ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

