/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.services.iot.model.AttributesCopier;
import software.amazon.awssdk.services.iot.model.ThingGroupNameListCopier;
import software.amazon.awssdk.services.iot.transform.ThingGroupDocumentMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ThingGroupDocument
implements StructuredPojo,
ToCopyableBuilder<Builder, ThingGroupDocument> {
    private final String thingGroupName;
    private final String thingGroupId;
    private final String thingGroupDescription;
    private final Map<String, String> attributes;
    private final List<String> parentGroupNames;

    private ThingGroupDocument(BuilderImpl builder) {
        this.thingGroupName = builder.thingGroupName;
        this.thingGroupId = builder.thingGroupId;
        this.thingGroupDescription = builder.thingGroupDescription;
        this.attributes = builder.attributes;
        this.parentGroupNames = builder.parentGroupNames;
    }

    public String thingGroupName() {
        return this.thingGroupName;
    }

    public String thingGroupId() {
        return this.thingGroupId;
    }

    public String thingGroupDescription() {
        return this.thingGroupDescription;
    }

    public Map<String, String> attributes() {
        return this.attributes;
    }

    public List<String> parentGroupNames() {
        return this.parentGroupNames;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.thingGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.thingGroupId());
        hashCode = 31 * hashCode + Objects.hashCode(this.thingGroupDescription());
        hashCode = 31 * hashCode + Objects.hashCode(this.attributes());
        hashCode = 31 * hashCode + Objects.hashCode(this.parentGroupNames());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ThingGroupDocument)) {
            return false;
        }
        ThingGroupDocument other = (ThingGroupDocument)obj;
        return Objects.equals(this.thingGroupName(), other.thingGroupName()) && Objects.equals(this.thingGroupId(), other.thingGroupId()) && Objects.equals(this.thingGroupDescription(), other.thingGroupDescription()) && Objects.equals(this.attributes(), other.attributes()) && Objects.equals(this.parentGroupNames(), other.parentGroupNames());
    }

    public String toString() {
        return ToString.builder((String)"ThingGroupDocument").add("ThingGroupName", (Object)this.thingGroupName()).add("ThingGroupId", (Object)this.thingGroupId()).add("ThingGroupDescription", (Object)this.thingGroupDescription()).add("Attributes", this.attributes()).add("ParentGroupNames", this.parentGroupNames()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "thingGroupName": {
                return Optional.ofNullable(clazz.cast(this.thingGroupName()));
            }
            case "thingGroupId": {
                return Optional.ofNullable(clazz.cast(this.thingGroupId()));
            }
            case "thingGroupDescription": {
                return Optional.ofNullable(clazz.cast(this.thingGroupDescription()));
            }
            case "attributes": {
                return Optional.ofNullable(clazz.cast(this.attributes()));
            }
            case "parentGroupNames": {
                return Optional.ofNullable(clazz.cast(this.parentGroupNames()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ThingGroupDocumentMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String thingGroupName;
        private String thingGroupId;
        private String thingGroupDescription;
        private Map<String, String> attributes = DefaultSdkAutoConstructMap.getInstance();
        private List<String> parentGroupNames = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ThingGroupDocument model) {
            this.thingGroupName(model.thingGroupName);
            this.thingGroupId(model.thingGroupId);
            this.thingGroupDescription(model.thingGroupDescription);
            this.attributes(model.attributes);
            this.parentGroupNames(model.parentGroupNames);
        }

        public final String getThingGroupName() {
            return this.thingGroupName;
        }

        @Override
        public final Builder thingGroupName(String thingGroupName) {
            this.thingGroupName = thingGroupName;
            return this;
        }

        public final void setThingGroupName(String thingGroupName) {
            this.thingGroupName = thingGroupName;
        }

        public final String getThingGroupId() {
            return this.thingGroupId;
        }

        @Override
        public final Builder thingGroupId(String thingGroupId) {
            this.thingGroupId = thingGroupId;
            return this;
        }

        public final void setThingGroupId(String thingGroupId) {
            this.thingGroupId = thingGroupId;
        }

        public final String getThingGroupDescription() {
            return this.thingGroupDescription;
        }

        @Override
        public final Builder thingGroupDescription(String thingGroupDescription) {
            this.thingGroupDescription = thingGroupDescription;
            return this;
        }

        public final void setThingGroupDescription(String thingGroupDescription) {
            this.thingGroupDescription = thingGroupDescription;
        }

        public final Map<String, String> getAttributes() {
            return this.attributes;
        }

        @Override
        public final Builder attributes(Map<String, String> attributes) {
            this.attributes = AttributesCopier.copy(attributes);
            return this;
        }

        public final void setAttributes(Map<String, String> attributes) {
            this.attributes = AttributesCopier.copy(attributes);
        }

        public final Collection<String> getParentGroupNames() {
            return this.parentGroupNames;
        }

        @Override
        public final Builder parentGroupNames(Collection<String> parentGroupNames) {
            this.parentGroupNames = ThingGroupNameListCopier.copy(parentGroupNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder parentGroupNames(String ... parentGroupNames) {
            this.parentGroupNames(Arrays.asList(parentGroupNames));
            return this;
        }

        public final void setParentGroupNames(Collection<String> parentGroupNames) {
            this.parentGroupNames = ThingGroupNameListCopier.copy(parentGroupNames);
        }

        public ThingGroupDocument build() {
            return new ThingGroupDocument(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ThingGroupDocument> {
        public Builder thingGroupName(String var1);

        public Builder thingGroupId(String var1);

        public Builder thingGroupDescription(String var1);

        public Builder attributes(Map<String, String> var1);

        public Builder parentGroupNames(Collection<String> var1);

        public Builder parentGroupNames(String ... var1);
    }
}

