/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.time.Instant;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.iot.transform.TopicRuleListItemMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TopicRuleListItem
implements StructuredPojo,
ToCopyableBuilder<Builder, TopicRuleListItem> {
    private final String ruleArn;
    private final String ruleName;
    private final String topicPattern;
    private final Instant createdAt;
    private final Boolean ruleDisabled;

    private TopicRuleListItem(BuilderImpl builder) {
        this.ruleArn = builder.ruleArn;
        this.ruleName = builder.ruleName;
        this.topicPattern = builder.topicPattern;
        this.createdAt = builder.createdAt;
        this.ruleDisabled = builder.ruleDisabled;
    }

    public String ruleArn() {
        return this.ruleArn;
    }

    public String ruleName() {
        return this.ruleName;
    }

    public String topicPattern() {
        return this.topicPattern;
    }

    public Instant createdAt() {
        return this.createdAt;
    }

    public Boolean ruleDisabled() {
        return this.ruleDisabled;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.ruleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.ruleName());
        hashCode = 31 * hashCode + Objects.hashCode(this.topicPattern());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.ruleDisabled());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TopicRuleListItem)) {
            return false;
        }
        TopicRuleListItem other = (TopicRuleListItem)obj;
        return Objects.equals(this.ruleArn(), other.ruleArn()) && Objects.equals(this.ruleName(), other.ruleName()) && Objects.equals(this.topicPattern(), other.topicPattern()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.ruleDisabled(), other.ruleDisabled());
    }

    public String toString() {
        return ToString.builder((String)"TopicRuleListItem").add("RuleArn", (Object)this.ruleArn()).add("RuleName", (Object)this.ruleName()).add("TopicPattern", (Object)this.topicPattern()).add("CreatedAt", (Object)this.createdAt()).add("RuleDisabled", (Object)this.ruleDisabled()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ruleArn": {
                return Optional.ofNullable(clazz.cast(this.ruleArn()));
            }
            case "ruleName": {
                return Optional.ofNullable(clazz.cast(this.ruleName()));
            }
            case "topicPattern": {
                return Optional.ofNullable(clazz.cast(this.topicPattern()));
            }
            case "createdAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "ruleDisabled": {
                return Optional.ofNullable(clazz.cast(this.ruleDisabled()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        TopicRuleListItemMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String ruleArn;
        private String ruleName;
        private String topicPattern;
        private Instant createdAt;
        private Boolean ruleDisabled;

        private BuilderImpl() {
        }

        private BuilderImpl(TopicRuleListItem model) {
            this.ruleArn(model.ruleArn);
            this.ruleName(model.ruleName);
            this.topicPattern(model.topicPattern);
            this.createdAt(model.createdAt);
            this.ruleDisabled(model.ruleDisabled);
        }

        public final String getRuleArn() {
            return this.ruleArn;
        }

        @Override
        public final Builder ruleArn(String ruleArn) {
            this.ruleArn = ruleArn;
            return this;
        }

        public final void setRuleArn(String ruleArn) {
            this.ruleArn = ruleArn;
        }

        public final String getRuleName() {
            return this.ruleName;
        }

        @Override
        public final Builder ruleName(String ruleName) {
            this.ruleName = ruleName;
            return this;
        }

        public final void setRuleName(String ruleName) {
            this.ruleName = ruleName;
        }

        public final String getTopicPattern() {
            return this.topicPattern;
        }

        @Override
        public final Builder topicPattern(String topicPattern) {
            this.topicPattern = topicPattern;
            return this;
        }

        public final void setTopicPattern(String topicPattern) {
            this.topicPattern = topicPattern;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        public final Boolean getRuleDisabled() {
            return this.ruleDisabled;
        }

        @Override
        public final Builder ruleDisabled(Boolean ruleDisabled) {
            this.ruleDisabled = ruleDisabled;
            return this;
        }

        public final void setRuleDisabled(Boolean ruleDisabled) {
            this.ruleDisabled = ruleDisabled;
        }

        public TopicRuleListItem build() {
            return new TopicRuleListItem(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, TopicRuleListItem> {
        public Builder ruleArn(String var1);

        public Builder ruleName(String var1);

        public Builder topicPattern(String var1);

        public Builder createdAt(Instant var1);

        public Builder ruleDisabled(Boolean var1);
    }
}

