/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.runtime.TypeConverter;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.services.iot.model.AuditCheckConfiguration;
import software.amazon.awssdk.services.iot.model.AuditCheckConfigurationsCopier;
import software.amazon.awssdk.services.iot.model.AuditNotificationTarget;
import software.amazon.awssdk.services.iot.model.AuditNotificationTargetConfigurationsCopier;
import software.amazon.awssdk.services.iot.model.AuditNotificationType;
import software.amazon.awssdk.services.iot.model.IotRequest;
import software.amazon.awssdk.utils.CollectionUtils;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateAccountAuditConfigurationRequest
extends IotRequest
implements ToCopyableBuilder<Builder, UpdateAccountAuditConfigurationRequest> {
    private final String roleArn;
    private final Map<String, AuditNotificationTarget> auditNotificationTargetConfigurations;
    private final Map<String, AuditCheckConfiguration> auditCheckConfigurations;

    private UpdateAccountAuditConfigurationRequest(BuilderImpl builder) {
        super(builder);
        this.roleArn = builder.roleArn;
        this.auditNotificationTargetConfigurations = builder.auditNotificationTargetConfigurations;
        this.auditCheckConfigurations = builder.auditCheckConfigurations;
    }

    public String roleArn() {
        return this.roleArn;
    }

    public Map<AuditNotificationType, AuditNotificationTarget> auditNotificationTargetConfigurations() {
        return TypeConverter.convert(this.auditNotificationTargetConfigurations, AuditNotificationType::fromValue, Function.identity(), (k, v) -> !Objects.equals(k, (Object)AuditNotificationType.UNKNOWN_TO_SDK_VERSION));
    }

    public Map<String, AuditNotificationTarget> auditNotificationTargetConfigurationsAsStrings() {
        return this.auditNotificationTargetConfigurations;
    }

    public Map<String, AuditCheckConfiguration> auditCheckConfigurations() {
        return this.auditCheckConfigurations;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.auditNotificationTargetConfigurationsAsStrings());
        hashCode = 31 * hashCode + Objects.hashCode(this.auditCheckConfigurations());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateAccountAuditConfigurationRequest)) {
            return false;
        }
        UpdateAccountAuditConfigurationRequest other = (UpdateAccountAuditConfigurationRequest)((Object)obj);
        return Objects.equals(this.roleArn(), other.roleArn()) && Objects.equals(this.auditNotificationTargetConfigurationsAsStrings(), other.auditNotificationTargetConfigurationsAsStrings()) && Objects.equals(this.auditCheckConfigurations(), other.auditCheckConfigurations());
    }

    public String toString() {
        return ToString.builder((String)"UpdateAccountAuditConfigurationRequest").add("RoleArn", (Object)this.roleArn()).add("AuditNotificationTargetConfigurations", this.auditNotificationTargetConfigurationsAsStrings()).add("AuditCheckConfigurations", this.auditCheckConfigurations()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "roleArn": {
                return Optional.ofNullable(clazz.cast(this.roleArn()));
            }
            case "auditNotificationTargetConfigurations": {
                return Optional.ofNullable(clazz.cast(this.auditNotificationTargetConfigurationsAsStrings()));
            }
            case "auditCheckConfigurations": {
                return Optional.ofNullable(clazz.cast(this.auditCheckConfigurations()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends IotRequest.BuilderImpl
    implements Builder {
        private String roleArn;
        private Map<String, AuditNotificationTarget> auditNotificationTargetConfigurations = DefaultSdkAutoConstructMap.getInstance();
        private Map<String, AuditCheckConfiguration> auditCheckConfigurations = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateAccountAuditConfigurationRequest model) {
            super(model);
            this.roleArn(model.roleArn);
            this.auditNotificationTargetConfigurationsWithStrings(model.auditNotificationTargetConfigurations);
            this.auditCheckConfigurations(model.auditCheckConfigurations);
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        public final Map<String, AuditNotificationTarget.Builder> getAuditNotificationTargetConfigurations() {
            return this.auditNotificationTargetConfigurations != null ? CollectionUtils.mapValues(this.auditNotificationTargetConfigurations, AuditNotificationTarget::toBuilder) : null;
        }

        @Override
        public final Builder auditNotificationTargetConfigurationsWithStrings(Map<String, AuditNotificationTarget> auditNotificationTargetConfigurations) {
            this.auditNotificationTargetConfigurations = AuditNotificationTargetConfigurationsCopier.copy(auditNotificationTargetConfigurations);
            return this;
        }

        @Override
        public final Builder auditNotificationTargetConfigurations(Map<AuditNotificationType, AuditNotificationTarget> auditNotificationTargetConfigurations) {
            this.auditNotificationTargetConfigurations = AuditNotificationTargetConfigurationsCopier.copyEnumToString(auditNotificationTargetConfigurations);
            return this;
        }

        public final void setAuditNotificationTargetConfigurations(Map<String, AuditNotificationTarget.BuilderImpl> auditNotificationTargetConfigurations) {
            this.auditNotificationTargetConfigurations = AuditNotificationTargetConfigurationsCopier.copyFromBuilder(auditNotificationTargetConfigurations);
        }

        public final Map<String, AuditCheckConfiguration.Builder> getAuditCheckConfigurations() {
            return this.auditCheckConfigurations != null ? CollectionUtils.mapValues(this.auditCheckConfigurations, AuditCheckConfiguration::toBuilder) : null;
        }

        @Override
        public final Builder auditCheckConfigurations(Map<String, AuditCheckConfiguration> auditCheckConfigurations) {
            this.auditCheckConfigurations = AuditCheckConfigurationsCopier.copy(auditCheckConfigurations);
            return this;
        }

        public final void setAuditCheckConfigurations(Map<String, AuditCheckConfiguration.BuilderImpl> auditCheckConfigurations) {
            this.auditCheckConfigurations = AuditCheckConfigurationsCopier.copyFromBuilder(auditCheckConfigurations);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateAccountAuditConfigurationRequest build() {
            return new UpdateAccountAuditConfigurationRequest(this);
        }
    }

    public static interface Builder
    extends IotRequest.Builder,
    CopyableBuilder<Builder, UpdateAccountAuditConfigurationRequest> {
        public Builder roleArn(String var1);

        public Builder auditNotificationTargetConfigurationsWithStrings(Map<String, AuditNotificationTarget> var1);

        public Builder auditNotificationTargetConfigurations(Map<AuditNotificationType, AuditNotificationTarget> var1);

        public Builder auditCheckConfigurations(Map<String, AuditCheckConfiguration> var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

