/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.runtime.TypeConverter;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.services.iot.model.AlertTarget;
import software.amazon.awssdk.services.iot.model.AlertTargetType;
import software.amazon.awssdk.services.iot.model.AlertTargetsCopier;
import software.amazon.awssdk.services.iot.model.Behavior;
import software.amazon.awssdk.services.iot.model.BehaviorsCopier;
import software.amazon.awssdk.services.iot.model.IotResponse;
import software.amazon.awssdk.utils.CollectionUtils;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateSecurityProfileResponse
extends IotResponse
implements ToCopyableBuilder<Builder, UpdateSecurityProfileResponse> {
    private final String securityProfileName;
    private final String securityProfileArn;
    private final String securityProfileDescription;
    private final List<Behavior> behaviors;
    private final Map<String, AlertTarget> alertTargets;
    private final Long version;
    private final Instant creationDate;
    private final Instant lastModifiedDate;

    private UpdateSecurityProfileResponse(BuilderImpl builder) {
        super(builder);
        this.securityProfileName = builder.securityProfileName;
        this.securityProfileArn = builder.securityProfileArn;
        this.securityProfileDescription = builder.securityProfileDescription;
        this.behaviors = builder.behaviors;
        this.alertTargets = builder.alertTargets;
        this.version = builder.version;
        this.creationDate = builder.creationDate;
        this.lastModifiedDate = builder.lastModifiedDate;
    }

    public String securityProfileName() {
        return this.securityProfileName;
    }

    public String securityProfileArn() {
        return this.securityProfileArn;
    }

    public String securityProfileDescription() {
        return this.securityProfileDescription;
    }

    public List<Behavior> behaviors() {
        return this.behaviors;
    }

    public Map<AlertTargetType, AlertTarget> alertTargets() {
        return TypeConverter.convert(this.alertTargets, AlertTargetType::fromValue, Function.identity(), (k, v) -> !Objects.equals(k, (Object)AlertTargetType.UNKNOWN_TO_SDK_VERSION));
    }

    public Map<String, AlertTarget> alertTargetsAsStrings() {
        return this.alertTargets;
    }

    public Long version() {
        return this.version;
    }

    public Instant creationDate() {
        return this.creationDate;
    }

    public Instant lastModifiedDate() {
        return this.lastModifiedDate;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.securityProfileName());
        hashCode = 31 * hashCode + Objects.hashCode(this.securityProfileArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.securityProfileDescription());
        hashCode = 31 * hashCode + Objects.hashCode(this.behaviors());
        hashCode = 31 * hashCode + Objects.hashCode(this.alertTargetsAsStrings());
        hashCode = 31 * hashCode + Objects.hashCode(this.version());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModifiedDate());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateSecurityProfileResponse)) {
            return false;
        }
        UpdateSecurityProfileResponse other = (UpdateSecurityProfileResponse)((Object)obj);
        return Objects.equals(this.securityProfileName(), other.securityProfileName()) && Objects.equals(this.securityProfileArn(), other.securityProfileArn()) && Objects.equals(this.securityProfileDescription(), other.securityProfileDescription()) && Objects.equals(this.behaviors(), other.behaviors()) && Objects.equals(this.alertTargetsAsStrings(), other.alertTargetsAsStrings()) && Objects.equals(this.version(), other.version()) && Objects.equals(this.creationDate(), other.creationDate()) && Objects.equals(this.lastModifiedDate(), other.lastModifiedDate());
    }

    public String toString() {
        return ToString.builder((String)"UpdateSecurityProfileResponse").add("SecurityProfileName", (Object)this.securityProfileName()).add("SecurityProfileArn", (Object)this.securityProfileArn()).add("SecurityProfileDescription", (Object)this.securityProfileDescription()).add("Behaviors", this.behaviors()).add("AlertTargets", this.alertTargetsAsStrings()).add("Version", (Object)this.version()).add("CreationDate", (Object)this.creationDate()).add("LastModifiedDate", (Object)this.lastModifiedDate()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "securityProfileName": {
                return Optional.ofNullable(clazz.cast(this.securityProfileName()));
            }
            case "securityProfileArn": {
                return Optional.ofNullable(clazz.cast(this.securityProfileArn()));
            }
            case "securityProfileDescription": {
                return Optional.ofNullable(clazz.cast(this.securityProfileDescription()));
            }
            case "behaviors": {
                return Optional.ofNullable(clazz.cast(this.behaviors()));
            }
            case "alertTargets": {
                return Optional.ofNullable(clazz.cast(this.alertTargetsAsStrings()));
            }
            case "version": {
                return Optional.ofNullable(clazz.cast(this.version()));
            }
            case "creationDate": {
                return Optional.ofNullable(clazz.cast(this.creationDate()));
            }
            case "lastModifiedDate": {
                return Optional.ofNullable(clazz.cast(this.lastModifiedDate()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends IotResponse.BuilderImpl
    implements Builder {
        private String securityProfileName;
        private String securityProfileArn;
        private String securityProfileDescription;
        private List<Behavior> behaviors = DefaultSdkAutoConstructList.getInstance();
        private Map<String, AlertTarget> alertTargets = DefaultSdkAutoConstructMap.getInstance();
        private Long version;
        private Instant creationDate;
        private Instant lastModifiedDate;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateSecurityProfileResponse model) {
            super(model);
            this.securityProfileName(model.securityProfileName);
            this.securityProfileArn(model.securityProfileArn);
            this.securityProfileDescription(model.securityProfileDescription);
            this.behaviors(model.behaviors);
            this.alertTargetsWithStrings(model.alertTargets);
            this.version(model.version);
            this.creationDate(model.creationDate);
            this.lastModifiedDate(model.lastModifiedDate);
        }

        public final String getSecurityProfileName() {
            return this.securityProfileName;
        }

        @Override
        public final Builder securityProfileName(String securityProfileName) {
            this.securityProfileName = securityProfileName;
            return this;
        }

        public final void setSecurityProfileName(String securityProfileName) {
            this.securityProfileName = securityProfileName;
        }

        public final String getSecurityProfileArn() {
            return this.securityProfileArn;
        }

        @Override
        public final Builder securityProfileArn(String securityProfileArn) {
            this.securityProfileArn = securityProfileArn;
            return this;
        }

        public final void setSecurityProfileArn(String securityProfileArn) {
            this.securityProfileArn = securityProfileArn;
        }

        public final String getSecurityProfileDescription() {
            return this.securityProfileDescription;
        }

        @Override
        public final Builder securityProfileDescription(String securityProfileDescription) {
            this.securityProfileDescription = securityProfileDescription;
            return this;
        }

        public final void setSecurityProfileDescription(String securityProfileDescription) {
            this.securityProfileDescription = securityProfileDescription;
        }

        public final Collection<Behavior.Builder> getBehaviors() {
            return this.behaviors != null ? (Collection)this.behaviors.stream().map(Behavior::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder behaviors(Collection<Behavior> behaviors) {
            this.behaviors = BehaviorsCopier.copy(behaviors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder behaviors(Behavior ... behaviors) {
            this.behaviors(Arrays.asList(behaviors));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder behaviors(Consumer<Behavior.Builder> ... behaviors) {
            this.behaviors(Stream.of(behaviors).map(c -> (Behavior)((Behavior.Builder)Behavior.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setBehaviors(Collection<Behavior.BuilderImpl> behaviors) {
            this.behaviors = BehaviorsCopier.copyFromBuilder(behaviors);
        }

        public final Map<String, AlertTarget.Builder> getAlertTargets() {
            return this.alertTargets != null ? CollectionUtils.mapValues(this.alertTargets, AlertTarget::toBuilder) : null;
        }

        @Override
        public final Builder alertTargetsWithStrings(Map<String, AlertTarget> alertTargets) {
            this.alertTargets = AlertTargetsCopier.copy(alertTargets);
            return this;
        }

        @Override
        public final Builder alertTargets(Map<AlertTargetType, AlertTarget> alertTargets) {
            this.alertTargets = AlertTargetsCopier.copyEnumToString(alertTargets);
            return this;
        }

        public final void setAlertTargets(Map<String, AlertTarget.BuilderImpl> alertTargets) {
            this.alertTargets = AlertTargetsCopier.copyFromBuilder(alertTargets);
        }

        public final Long getVersion() {
            return this.version;
        }

        @Override
        public final Builder version(Long version) {
            this.version = version;
            return this;
        }

        public final void setVersion(Long version) {
            this.version = version;
        }

        public final Instant getCreationDate() {
            return this.creationDate;
        }

        @Override
        public final Builder creationDate(Instant creationDate) {
            this.creationDate = creationDate;
            return this;
        }

        public final void setCreationDate(Instant creationDate) {
            this.creationDate = creationDate;
        }

        public final Instant getLastModifiedDate() {
            return this.lastModifiedDate;
        }

        @Override
        public final Builder lastModifiedDate(Instant lastModifiedDate) {
            this.lastModifiedDate = lastModifiedDate;
            return this;
        }

        public final void setLastModifiedDate(Instant lastModifiedDate) {
            this.lastModifiedDate = lastModifiedDate;
        }

        @Override
        public UpdateSecurityProfileResponse build() {
            return new UpdateSecurityProfileResponse(this);
        }
    }

    public static interface Builder
    extends IotResponse.Builder,
    CopyableBuilder<Builder, UpdateSecurityProfileResponse> {
        public Builder securityProfileName(String var1);

        public Builder securityProfileArn(String var1);

        public Builder securityProfileDescription(String var1);

        public Builder behaviors(Collection<Behavior> var1);

        public Builder behaviors(Behavior ... var1);

        public Builder behaviors(Consumer<Behavior.Builder> ... var1);

        public Builder alertTargetsWithStrings(Map<String, AlertTarget> var1);

        public Builder alertTargets(Map<AlertTargetType, AlertTarget> var1);

        public Builder version(Long var1);

        public Builder creationDate(Instant var1);

        public Builder lastModifiedDate(Instant var1);
    }
}

