/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.services.iot.model.IotResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateStreamResponse
extends IotResponse
implements ToCopyableBuilder<Builder, UpdateStreamResponse> {
    private final String streamId;
    private final String streamArn;
    private final String description;
    private final Integer streamVersion;

    private UpdateStreamResponse(BuilderImpl builder) {
        super(builder);
        this.streamId = builder.streamId;
        this.streamArn = builder.streamArn;
        this.description = builder.description;
        this.streamVersion = builder.streamVersion;
    }

    public String streamId() {
        return this.streamId;
    }

    public String streamArn() {
        return this.streamArn;
    }

    public String description() {
        return this.description;
    }

    public Integer streamVersion() {
        return this.streamVersion;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.streamId());
        hashCode = 31 * hashCode + Objects.hashCode(this.streamArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.streamVersion());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateStreamResponse)) {
            return false;
        }
        UpdateStreamResponse other = (UpdateStreamResponse)((Object)obj);
        return Objects.equals(this.streamId(), other.streamId()) && Objects.equals(this.streamArn(), other.streamArn()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.streamVersion(), other.streamVersion());
    }

    public String toString() {
        return ToString.builder((String)"UpdateStreamResponse").add("StreamId", (Object)this.streamId()).add("StreamArn", (Object)this.streamArn()).add("Description", (Object)this.description()).add("StreamVersion", (Object)this.streamVersion()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "streamId": {
                return Optional.ofNullable(clazz.cast(this.streamId()));
            }
            case "streamArn": {
                return Optional.ofNullable(clazz.cast(this.streamArn()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "streamVersion": {
                return Optional.ofNullable(clazz.cast(this.streamVersion()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends IotResponse.BuilderImpl
    implements Builder {
        private String streamId;
        private String streamArn;
        private String description;
        private Integer streamVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateStreamResponse model) {
            super(model);
            this.streamId(model.streamId);
            this.streamArn(model.streamArn);
            this.description(model.description);
            this.streamVersion(model.streamVersion);
        }

        public final String getStreamId() {
            return this.streamId;
        }

        @Override
        public final Builder streamId(String streamId) {
            this.streamId = streamId;
            return this;
        }

        public final void setStreamId(String streamId) {
            this.streamId = streamId;
        }

        public final String getStreamArn() {
            return this.streamArn;
        }

        @Override
        public final Builder streamArn(String streamArn) {
            this.streamArn = streamArn;
            return this;
        }

        public final void setStreamArn(String streamArn) {
            this.streamArn = streamArn;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final Integer getStreamVersion() {
            return this.streamVersion;
        }

        @Override
        public final Builder streamVersion(Integer streamVersion) {
            this.streamVersion = streamVersion;
            return this;
        }

        public final void setStreamVersion(Integer streamVersion) {
            this.streamVersion = streamVersion;
        }

        @Override
        public UpdateStreamResponse build() {
            return new UpdateStreamResponse(this);
        }
    }

    public static interface Builder
    extends IotResponse.Builder,
    CopyableBuilder<Builder, UpdateStreamResponse> {
        public Builder streamId(String var1);

        public Builder streamArn(String var1);

        public Builder description(String var1);

        public Builder streamVersion(Integer var1);
    }
}

