/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.transform;

import com.fasterxml.jackson.core.JsonToken;
import software.amazon.awssdk.core.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.iot.model.Action;
import software.amazon.awssdk.services.iot.transform.CloudwatchAlarmActionUnmarshaller;
import software.amazon.awssdk.services.iot.transform.CloudwatchMetricActionUnmarshaller;
import software.amazon.awssdk.services.iot.transform.DynamoDBActionUnmarshaller;
import software.amazon.awssdk.services.iot.transform.DynamoDBv2ActionUnmarshaller;
import software.amazon.awssdk.services.iot.transform.ElasticsearchActionUnmarshaller;
import software.amazon.awssdk.services.iot.transform.FirehoseActionUnmarshaller;
import software.amazon.awssdk.services.iot.transform.IotAnalyticsActionUnmarshaller;
import software.amazon.awssdk.services.iot.transform.KinesisActionUnmarshaller;
import software.amazon.awssdk.services.iot.transform.LambdaActionUnmarshaller;
import software.amazon.awssdk.services.iot.transform.RepublishActionUnmarshaller;
import software.amazon.awssdk.services.iot.transform.S3ActionUnmarshaller;
import software.amazon.awssdk.services.iot.transform.SalesforceActionUnmarshaller;
import software.amazon.awssdk.services.iot.transform.SnsActionUnmarshaller;
import software.amazon.awssdk.services.iot.transform.SqsActionUnmarshaller;
import software.amazon.awssdk.services.iot.transform.StepFunctionsActionUnmarshaller;

public class ActionUnmarshaller
implements Unmarshaller<Action, JsonUnmarshallerContext> {
    private static final ActionUnmarshaller INSTANCE = new ActionUnmarshaller();

    public Action unmarshall(JsonUnmarshallerContext context) throws Exception {
        Action.Builder actionBuilder = Action.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("dynamoDB", targetDepth)) {
                    context.nextToken();
                    actionBuilder.dynamoDB(DynamoDBActionUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("dynamoDBv2", targetDepth)) {
                    context.nextToken();
                    actionBuilder.dynamoDBv2(DynamoDBv2ActionUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("lambda", targetDepth)) {
                    context.nextToken();
                    actionBuilder.lambda(LambdaActionUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("sns", targetDepth)) {
                    context.nextToken();
                    actionBuilder.sns(SnsActionUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("sqs", targetDepth)) {
                    context.nextToken();
                    actionBuilder.sqs(SqsActionUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("kinesis", targetDepth)) {
                    context.nextToken();
                    actionBuilder.kinesis(KinesisActionUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("republish", targetDepth)) {
                    context.nextToken();
                    actionBuilder.republish(RepublishActionUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("s3", targetDepth)) {
                    context.nextToken();
                    actionBuilder.s3(S3ActionUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("firehose", targetDepth)) {
                    context.nextToken();
                    actionBuilder.firehose(FirehoseActionUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("cloudwatchMetric", targetDepth)) {
                    context.nextToken();
                    actionBuilder.cloudwatchMetric(CloudwatchMetricActionUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("cloudwatchAlarm", targetDepth)) {
                    context.nextToken();
                    actionBuilder.cloudwatchAlarm(CloudwatchAlarmActionUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("elasticsearch", targetDepth)) {
                    context.nextToken();
                    actionBuilder.elasticsearch(ElasticsearchActionUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("salesforce", targetDepth)) {
                    context.nextToken();
                    actionBuilder.salesforce(SalesforceActionUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("iotAnalytics", targetDepth)) {
                    context.nextToken();
                    actionBuilder.iotAnalytics(IotAnalyticsActionUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("stepFunctions", targetDepth)) {
                    context.nextToken();
                    actionBuilder.stepFunctions(StepFunctionsActionUnmarshaller.getInstance().unmarshall(context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (Action)actionBuilder.build();
    }

    public static ActionUnmarshaller getInstance() {
        return INSTANCE;
    }
}

