/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.iot.model.AuditTaskMetadata;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class AuditTaskMetadataMarshaller {
    private static final MarshallingInfo<String> TASKID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("taskId").isBinary(false).build();
    private static final MarshallingInfo<String> TASKSTATUS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("taskStatus").isBinary(false).build();
    private static final MarshallingInfo<String> TASKTYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("taskType").isBinary(false).build();
    private static final AuditTaskMetadataMarshaller INSTANCE = new AuditTaskMetadataMarshaller();

    private AuditTaskMetadataMarshaller() {
    }

    public static AuditTaskMetadataMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(AuditTaskMetadata auditTaskMetadata, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)auditTaskMetadata, (String)"auditTaskMetadata");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)auditTaskMetadata.taskId(), TASKID_BINDING);
            protocolMarshaller.marshall((Object)auditTaskMetadata.taskStatusAsString(), TASKSTATUS_BINDING);
            protocolMarshaller.marshall((Object)auditTaskMetadata.taskTypeAsString(), TASKTYPE_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

