/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.transform;

import com.fasterxml.jackson.core.JsonToken;
import software.amazon.awssdk.core.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.ListUnmarshaller;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.iot.model.AuthResult;
import software.amazon.awssdk.services.iot.transform.AllowedUnmarshaller;
import software.amazon.awssdk.services.iot.transform.AuthInfoUnmarshaller;
import software.amazon.awssdk.services.iot.transform.DeniedUnmarshaller;

public class AuthResultUnmarshaller
implements Unmarshaller<AuthResult, JsonUnmarshallerContext> {
    private static final AuthResultUnmarshaller INSTANCE = new AuthResultUnmarshaller();

    public AuthResult unmarshall(JsonUnmarshallerContext context) throws Exception {
        AuthResult.Builder authResultBuilder = AuthResult.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("authInfo", targetDepth)) {
                    context.nextToken();
                    authResultBuilder.authInfo(AuthInfoUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("allowed", targetDepth)) {
                    context.nextToken();
                    authResultBuilder.allowed(AllowedUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("denied", targetDepth)) {
                    context.nextToken();
                    authResultBuilder.denied(DeniedUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("authDecision", targetDepth)) {
                    context.nextToken();
                    authResultBuilder.authDecision((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("missingContextValues", targetDepth)) {
                    context.nextToken();
                    authResultBuilder.missingContextValues(new ListUnmarshaller(context.getUnmarshaller(String.class)).unmarshall(context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (AuthResult)authResultBuilder.build();
    }

    public static AuthResultUnmarshaller getInstance() {
        return INSTANCE;
    }
}

