/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.iot.model.AuthorizerSummary;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class AuthorizerSummaryMarshaller {
    private static final MarshallingInfo<String> AUTHORIZERNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("authorizerName").isBinary(false).build();
    private static final MarshallingInfo<String> AUTHORIZERARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("authorizerArn").isBinary(false).build();
    private static final AuthorizerSummaryMarshaller INSTANCE = new AuthorizerSummaryMarshaller();

    private AuthorizerSummaryMarshaller() {
    }

    public static AuthorizerSummaryMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(AuthorizerSummary authorizerSummary, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)authorizerSummary, (String)"authorizerSummary");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)authorizerSummary.authorizerName(), AUTHORIZERNAME_BINDING);
            protocolMarshaller.marshall((Object)authorizerSummary.authorizerArn(), AUTHORIZERARN_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

