/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.transform;

import com.fasterxml.jackson.core.JsonToken;
import java.time.Instant;
import software.amazon.awssdk.core.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.iot.model.Certificate;

public class CertificateUnmarshaller
implements Unmarshaller<Certificate, JsonUnmarshallerContext> {
    private static final CertificateUnmarshaller INSTANCE = new CertificateUnmarshaller();

    public Certificate unmarshall(JsonUnmarshallerContext context) throws Exception {
        Certificate.Builder certificateBuilder = Certificate.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("certificateArn", targetDepth)) {
                    context.nextToken();
                    certificateBuilder.certificateArn((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("certificateId", targetDepth)) {
                    context.nextToken();
                    certificateBuilder.certificateId((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("status", targetDepth)) {
                    context.nextToken();
                    certificateBuilder.status((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("creationDate", targetDepth)) {
                    context.nextToken();
                    certificateBuilder.creationDate((Instant)context.getUnmarshaller(Instant.class).unmarshall((Object)context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (Certificate)certificateBuilder.build();
    }

    public static CertificateUnmarshaller getInstance() {
        return INSTANCE;
    }
}

