/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.iot.model.CreateJobRequest;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class CreateJobRequestModelMarshaller {
    private static final MarshallingInfo<String> JOBID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PATH).marshallLocationName("jobId").isBinary(false).build();
    private static final MarshallingInfo<List> TARGETS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("targets").isBinary(false).build();
    private static final MarshallingInfo<String> DOCUMENTSOURCE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("documentSource").isBinary(false).build();
    private static final MarshallingInfo<String> DOCUMENT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("document").isBinary(false).build();
    private static final MarshallingInfo<String> DESCRIPTION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("description").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> PRESIGNEDURLCONFIG_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("presignedUrlConfig").isBinary(false).build();
    private static final MarshallingInfo<String> TARGETSELECTION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("targetSelection").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> JOBEXECUTIONSROLLOUTCONFIG_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("jobExecutionsRolloutConfig").isBinary(false).build();
    private static final CreateJobRequestModelMarshaller INSTANCE = new CreateJobRequestModelMarshaller();

    private CreateJobRequestModelMarshaller() {
    }

    public static CreateJobRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(CreateJobRequest createJobRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)((Object)createJobRequest), (String)"createJobRequest");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)createJobRequest.jobId(), JOBID_BINDING);
            protocolMarshaller.marshall(createJobRequest.targets(), TARGETS_BINDING);
            protocolMarshaller.marshall((Object)createJobRequest.documentSource(), DOCUMENTSOURCE_BINDING);
            protocolMarshaller.marshall((Object)createJobRequest.document(), DOCUMENT_BINDING);
            protocolMarshaller.marshall((Object)createJobRequest.description(), DESCRIPTION_BINDING);
            protocolMarshaller.marshall((Object)createJobRequest.presignedUrlConfig(), PRESIGNEDURLCONFIG_BINDING);
            protocolMarshaller.marshall((Object)createJobRequest.targetSelectionAsString(), TARGETSELECTION_BINDING);
            protocolMarshaller.marshall((Object)createJobRequest.jobExecutionsRolloutConfig(), JOBEXECUTIONSROLLOUTCONFIG_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

