/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.transform;

import java.util.List;
import java.util.Map;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.iot.model.CreateSecurityProfileRequest;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class CreateSecurityProfileRequestModelMarshaller {
    private static final MarshallingInfo<String> SECURITYPROFILENAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PATH).marshallLocationName("securityProfileName").isBinary(false).build();
    private static final MarshallingInfo<String> SECURITYPROFILEDESCRIPTION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("securityProfileDescription").isBinary(false).build();
    private static final MarshallingInfo<List> BEHAVIORS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("behaviors").isBinary(false).build();
    private static final MarshallingInfo<Map> ALERTTARGETS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("alertTargets").isBinary(false).build();
    private static final CreateSecurityProfileRequestModelMarshaller INSTANCE = new CreateSecurityProfileRequestModelMarshaller();

    private CreateSecurityProfileRequestModelMarshaller() {
    }

    public static CreateSecurityProfileRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(CreateSecurityProfileRequest createSecurityProfileRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)((Object)createSecurityProfileRequest), (String)"createSecurityProfileRequest");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)createSecurityProfileRequest.securityProfileName(), SECURITYPROFILENAME_BINDING);
            protocolMarshaller.marshall((Object)createSecurityProfileRequest.securityProfileDescription(), SECURITYPROFILEDESCRIPTION_BINDING);
            protocolMarshaller.marshall(createSecurityProfileRequest.behaviors(), BEHAVIORS_BINDING);
            protocolMarshaller.marshall(createSecurityProfileRequest.alertTargetsAsStrings(), ALERTTARGETS_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

