/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.iot.model.CustomCodeSigning;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class CustomCodeSigningMarshaller {
    private static final MarshallingInfo<StructuredPojo> SIGNATURE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("signature").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> CERTIFICATECHAIN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("certificateChain").isBinary(false).build();
    private static final MarshallingInfo<String> HASHALGORITHM_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("hashAlgorithm").isBinary(false).build();
    private static final MarshallingInfo<String> SIGNATUREALGORITHM_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("signatureAlgorithm").isBinary(false).build();
    private static final CustomCodeSigningMarshaller INSTANCE = new CustomCodeSigningMarshaller();

    private CustomCodeSigningMarshaller() {
    }

    public static CustomCodeSigningMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(CustomCodeSigning customCodeSigning, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)customCodeSigning, (String)"customCodeSigning");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)customCodeSigning.signature(), SIGNATURE_BINDING);
            protocolMarshaller.marshall((Object)customCodeSigning.certificateChain(), CERTIFICATECHAIN_BINDING);
            protocolMarshaller.marshall((Object)customCodeSigning.hashAlgorithm(), HASHALGORITHM_BINDING);
            protocolMarshaller.marshall((Object)customCodeSigning.signatureAlgorithm(), SIGNATUREALGORITHM_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

