/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.iot.model.Denied;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class DeniedMarshaller {
    private static final MarshallingInfo<StructuredPojo> IMPLICITDENY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("implicitDeny").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> EXPLICITDENY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("explicitDeny").isBinary(false).build();
    private static final DeniedMarshaller INSTANCE = new DeniedMarshaller();

    private DeniedMarshaller() {
    }

    public static DeniedMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(Denied denied, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)denied, (String)"denied");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)denied.implicitDeny(), IMPLICITDENY_BINDING);
            protocolMarshaller.marshall((Object)denied.explicitDeny(), EXPLICITDENY_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

