/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.transform;

import com.fasterxml.jackson.core.JsonToken;
import software.amazon.awssdk.core.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.iot.model.FileLocation;
import software.amazon.awssdk.services.iot.transform.S3LocationUnmarshaller;
import software.amazon.awssdk.services.iot.transform.StreamUnmarshaller;

public class FileLocationUnmarshaller
implements Unmarshaller<FileLocation, JsonUnmarshallerContext> {
    private static final FileLocationUnmarshaller INSTANCE = new FileLocationUnmarshaller();

    public FileLocation unmarshall(JsonUnmarshallerContext context) throws Exception {
        FileLocation.Builder fileLocationBuilder = FileLocation.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("stream", targetDepth)) {
                    context.nextToken();
                    fileLocationBuilder.stream(StreamUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("s3Location", targetDepth)) {
                    context.nextToken();
                    fileLocationBuilder.s3Location(S3LocationUnmarshaller.getInstance().unmarshall(context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (FileLocation)fileLocationBuilder.build();
    }

    public static FileLocationUnmarshaller getInstance() {
        return INSTANCE;
    }
}

