/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.iot.model.FirehoseAction;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class FirehoseActionMarshaller {
    private static final MarshallingInfo<String> ROLEARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("roleArn").isBinary(false).build();
    private static final MarshallingInfo<String> DELIVERYSTREAMNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("deliveryStreamName").isBinary(false).build();
    private static final MarshallingInfo<String> SEPARATOR_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("separator").isBinary(false).build();
    private static final FirehoseActionMarshaller INSTANCE = new FirehoseActionMarshaller();

    private FirehoseActionMarshaller() {
    }

    public static FirehoseActionMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(FirehoseAction firehoseAction, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)firehoseAction, (String)"firehoseAction");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)firehoseAction.roleArn(), ROLEARN_BINDING);
            protocolMarshaller.marshall((Object)firehoseAction.deliveryStreamName(), DELIVERYSTREAMNAME_BINDING);
            protocolMarshaller.marshall((Object)firehoseAction.separator(), SEPARATOR_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

