/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.iot.model.GroupNameAndArn;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class GroupNameAndArnMarshaller {
    private static final MarshallingInfo<String> GROUPNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("groupName").isBinary(false).build();
    private static final MarshallingInfo<String> GROUPARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("groupArn").isBinary(false).build();
    private static final GroupNameAndArnMarshaller INSTANCE = new GroupNameAndArnMarshaller();

    private GroupNameAndArnMarshaller() {
    }

    public static GroupNameAndArnMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(GroupNameAndArn groupNameAndArn, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)groupNameAndArn, (String)"groupNameAndArn");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)groupNameAndArn.groupName(), GROUPNAME_BINDING);
            protocolMarshaller.marshall((Object)groupNameAndArn.groupArn(), GROUPARN_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

