/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.transform;

import java.time.Instant;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.iot.model.JobExecution;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class JobExecutionMarshaller {
    private static final MarshallingInfo<String> JOBID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("jobId").isBinary(false).build();
    private static final MarshallingInfo<String> STATUS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("status").isBinary(false).build();
    private static final MarshallingInfo<Boolean> FORCECANCELED_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("forceCanceled").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> STATUSDETAILS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("statusDetails").isBinary(false).build();
    private static final MarshallingInfo<String> THINGARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("thingArn").isBinary(false).build();
    private static final MarshallingInfo<Instant> QUEUEDAT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("queuedAt").isBinary(false).build();
    private static final MarshallingInfo<Instant> STARTEDAT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("startedAt").isBinary(false).build();
    private static final MarshallingInfo<Instant> LASTUPDATEDAT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("lastUpdatedAt").isBinary(false).build();
    private static final MarshallingInfo<Long> EXECUTIONNUMBER_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("executionNumber").isBinary(false).build();
    private static final MarshallingInfo<Long> VERSIONNUMBER_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("versionNumber").isBinary(false).build();
    private static final JobExecutionMarshaller INSTANCE = new JobExecutionMarshaller();

    private JobExecutionMarshaller() {
    }

    public static JobExecutionMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(JobExecution jobExecution, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)jobExecution, (String)"jobExecution");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)jobExecution.jobId(), JOBID_BINDING);
            protocolMarshaller.marshall((Object)jobExecution.statusAsString(), STATUS_BINDING);
            protocolMarshaller.marshall((Object)jobExecution.forceCanceled(), FORCECANCELED_BINDING);
            protocolMarshaller.marshall((Object)jobExecution.statusDetails(), STATUSDETAILS_BINDING);
            protocolMarshaller.marshall((Object)jobExecution.thingArn(), THINGARN_BINDING);
            protocolMarshaller.marshall((Object)jobExecution.queuedAt(), QUEUEDAT_BINDING);
            protocolMarshaller.marshall((Object)jobExecution.startedAt(), STARTEDAT_BINDING);
            protocolMarshaller.marshall((Object)jobExecution.lastUpdatedAt(), LASTUPDATEDAT_BINDING);
            protocolMarshaller.marshall((Object)jobExecution.executionNumber(), EXECUTIONNUMBER_BINDING);
            protocolMarshaller.marshall((Object)jobExecution.versionNumber(), VERSIONNUMBER_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

