/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.transform;

import java.time.Instant;
import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.iot.model.Job;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class JobMarshaller {
    private static final MarshallingInfo<String> JOBARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("jobArn").isBinary(false).build();
    private static final MarshallingInfo<String> JOBID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("jobId").isBinary(false).build();
    private static final MarshallingInfo<String> TARGETSELECTION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("targetSelection").isBinary(false).build();
    private static final MarshallingInfo<String> STATUS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("status").isBinary(false).build();
    private static final MarshallingInfo<Boolean> FORCECANCELED_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("forceCanceled").isBinary(false).build();
    private static final MarshallingInfo<String> COMMENT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("comment").isBinary(false).build();
    private static final MarshallingInfo<List> TARGETS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("targets").isBinary(false).build();
    private static final MarshallingInfo<String> DESCRIPTION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("description").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> PRESIGNEDURLCONFIG_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("presignedUrlConfig").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> JOBEXECUTIONSROLLOUTCONFIG_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("jobExecutionsRolloutConfig").isBinary(false).build();
    private static final MarshallingInfo<Instant> CREATEDAT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("createdAt").isBinary(false).build();
    private static final MarshallingInfo<Instant> LASTUPDATEDAT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("lastUpdatedAt").isBinary(false).build();
    private static final MarshallingInfo<Instant> COMPLETEDAT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("completedAt").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> JOBPROCESSDETAILS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("jobProcessDetails").isBinary(false).build();
    private static final JobMarshaller INSTANCE = new JobMarshaller();

    private JobMarshaller() {
    }

    public static JobMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(Job job, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)job, (String)"job");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)job.jobArn(), JOBARN_BINDING);
            protocolMarshaller.marshall((Object)job.jobId(), JOBID_BINDING);
            protocolMarshaller.marshall((Object)job.targetSelectionAsString(), TARGETSELECTION_BINDING);
            protocolMarshaller.marshall((Object)job.statusAsString(), STATUS_BINDING);
            protocolMarshaller.marshall((Object)job.forceCanceled(), FORCECANCELED_BINDING);
            protocolMarshaller.marshall((Object)job.comment(), COMMENT_BINDING);
            protocolMarshaller.marshall(job.targets(), TARGETS_BINDING);
            protocolMarshaller.marshall((Object)job.description(), DESCRIPTION_BINDING);
            protocolMarshaller.marshall((Object)job.presignedUrlConfig(), PRESIGNEDURLCONFIG_BINDING);
            protocolMarshaller.marshall((Object)job.jobExecutionsRolloutConfig(), JOBEXECUTIONSROLLOUTCONFIG_BINDING);
            protocolMarshaller.marshall((Object)job.createdAt(), CREATEDAT_BINDING);
            protocolMarshaller.marshall((Object)job.lastUpdatedAt(), LASTUPDATEDAT_BINDING);
            protocolMarshaller.marshall((Object)job.completedAt(), COMPLETEDAT_BINDING);
            protocolMarshaller.marshall((Object)job.jobProcessDetails(), JOBPROCESSDETAILS_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

