/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.iot.model.JobProcessDetails;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class JobProcessDetailsMarshaller {
    private static final MarshallingInfo<List> PROCESSINGTARGETS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("processingTargets").isBinary(false).build();
    private static final MarshallingInfo<Integer> NUMBEROFCANCELEDTHINGS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("numberOfCanceledThings").isBinary(false).build();
    private static final MarshallingInfo<Integer> NUMBEROFSUCCEEDEDTHINGS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("numberOfSucceededThings").isBinary(false).build();
    private static final MarshallingInfo<Integer> NUMBEROFFAILEDTHINGS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("numberOfFailedThings").isBinary(false).build();
    private static final MarshallingInfo<Integer> NUMBEROFREJECTEDTHINGS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("numberOfRejectedThings").isBinary(false).build();
    private static final MarshallingInfo<Integer> NUMBEROFQUEUEDTHINGS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("numberOfQueuedThings").isBinary(false).build();
    private static final MarshallingInfo<Integer> NUMBEROFINPROGRESSTHINGS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("numberOfInProgressThings").isBinary(false).build();
    private static final MarshallingInfo<Integer> NUMBEROFREMOVEDTHINGS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("numberOfRemovedThings").isBinary(false).build();
    private static final JobProcessDetailsMarshaller INSTANCE = new JobProcessDetailsMarshaller();

    private JobProcessDetailsMarshaller() {
    }

    public static JobProcessDetailsMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(JobProcessDetails jobProcessDetails, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)jobProcessDetails, (String)"jobProcessDetails");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall(jobProcessDetails.processingTargets(), PROCESSINGTARGETS_BINDING);
            protocolMarshaller.marshall((Object)jobProcessDetails.numberOfCanceledThings(), NUMBEROFCANCELEDTHINGS_BINDING);
            protocolMarshaller.marshall((Object)jobProcessDetails.numberOfSucceededThings(), NUMBEROFSUCCEEDEDTHINGS_BINDING);
            protocolMarshaller.marshall((Object)jobProcessDetails.numberOfFailedThings(), NUMBEROFFAILEDTHINGS_BINDING);
            protocolMarshaller.marshall((Object)jobProcessDetails.numberOfRejectedThings(), NUMBEROFREJECTEDTHINGS_BINDING);
            protocolMarshaller.marshall((Object)jobProcessDetails.numberOfQueuedThings(), NUMBEROFQUEUEDTHINGS_BINDING);
            protocolMarshaller.marshall((Object)jobProcessDetails.numberOfInProgressThings(), NUMBEROFINPROGRESSTHINGS_BINDING);
            protocolMarshaller.marshall((Object)jobProcessDetails.numberOfRemovedThings(), NUMBEROFREMOVEDTHINGS_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

