/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.transform;

import com.fasterxml.jackson.core.JsonToken;
import software.amazon.awssdk.core.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.ListUnmarshaller;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.iot.model.MetricValue;

public class MetricValueUnmarshaller
implements Unmarshaller<MetricValue, JsonUnmarshallerContext> {
    private static final MetricValueUnmarshaller INSTANCE = new MetricValueUnmarshaller();

    public MetricValue unmarshall(JsonUnmarshallerContext context) throws Exception {
        MetricValue.Builder metricValueBuilder = MetricValue.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("count", targetDepth)) {
                    context.nextToken();
                    metricValueBuilder.count((Long)context.getUnmarshaller(Long.class).unmarshall((Object)context));
                }
                if (context.testExpression("cidrs", targetDepth)) {
                    context.nextToken();
                    metricValueBuilder.cidrs(new ListUnmarshaller(context.getUnmarshaller(String.class)).unmarshall(context));
                }
                if (context.testExpression("ports", targetDepth)) {
                    context.nextToken();
                    metricValueBuilder.ports(new ListUnmarshaller(context.getUnmarshaller(Integer.class)).unmarshall(context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (MetricValue)metricValueBuilder.build();
    }

    public static MetricValueUnmarshaller getInstance() {
        return INSTANCE;
    }
}

