/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.transform;

import java.time.Instant;
import java.util.List;
import java.util.Map;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.iot.model.OTAUpdateInfo;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class OTAUpdateInfoMarshaller {
    private static final MarshallingInfo<String> OTAUPDATEID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("otaUpdateId").isBinary(false).build();
    private static final MarshallingInfo<String> OTAUPDATEARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("otaUpdateArn").isBinary(false).build();
    private static final MarshallingInfo<Instant> CREATIONDATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("creationDate").isBinary(false).build();
    private static final MarshallingInfo<Instant> LASTMODIFIEDDATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("lastModifiedDate").isBinary(false).build();
    private static final MarshallingInfo<String> DESCRIPTION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("description").isBinary(false).build();
    private static final MarshallingInfo<List> TARGETS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("targets").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> AWSJOBEXECUTIONSROLLOUTCONFIG_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("awsJobExecutionsRolloutConfig").isBinary(false).build();
    private static final MarshallingInfo<String> TARGETSELECTION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("targetSelection").isBinary(false).build();
    private static final MarshallingInfo<List> OTAUPDATEFILES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("otaUpdateFiles").isBinary(false).build();
    private static final MarshallingInfo<String> OTAUPDATESTATUS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("otaUpdateStatus").isBinary(false).build();
    private static final MarshallingInfo<String> AWSIOTJOBID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("awsIotJobId").isBinary(false).build();
    private static final MarshallingInfo<String> AWSIOTJOBARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("awsIotJobArn").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> ERRORINFO_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("errorInfo").isBinary(false).build();
    private static final MarshallingInfo<Map> ADDITIONALPARAMETERS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("additionalParameters").isBinary(false).build();
    private static final OTAUpdateInfoMarshaller INSTANCE = new OTAUpdateInfoMarshaller();

    private OTAUpdateInfoMarshaller() {
    }

    public static OTAUpdateInfoMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(OTAUpdateInfo otaUpdateInfo, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)otaUpdateInfo, (String)"otaUpdateInfo");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)otaUpdateInfo.otaUpdateId(), OTAUPDATEID_BINDING);
            protocolMarshaller.marshall((Object)otaUpdateInfo.otaUpdateArn(), OTAUPDATEARN_BINDING);
            protocolMarshaller.marshall((Object)otaUpdateInfo.creationDate(), CREATIONDATE_BINDING);
            protocolMarshaller.marshall((Object)otaUpdateInfo.lastModifiedDate(), LASTMODIFIEDDATE_BINDING);
            protocolMarshaller.marshall((Object)otaUpdateInfo.description(), DESCRIPTION_BINDING);
            protocolMarshaller.marshall(otaUpdateInfo.targets(), TARGETS_BINDING);
            protocolMarshaller.marshall((Object)otaUpdateInfo.awsJobExecutionsRolloutConfig(), AWSJOBEXECUTIONSROLLOUTCONFIG_BINDING);
            protocolMarshaller.marshall((Object)otaUpdateInfo.targetSelectionAsString(), TARGETSELECTION_BINDING);
            protocolMarshaller.marshall(otaUpdateInfo.otaUpdateFiles(), OTAUPDATEFILES_BINDING);
            protocolMarshaller.marshall((Object)otaUpdateInfo.otaUpdateStatusAsString(), OTAUPDATESTATUS_BINDING);
            protocolMarshaller.marshall((Object)otaUpdateInfo.awsIotJobId(), AWSIOTJOBID_BINDING);
            protocolMarshaller.marshall((Object)otaUpdateInfo.awsIotJobArn(), AWSIOTJOBARN_BINDING);
            protocolMarshaller.marshall((Object)otaUpdateInfo.errorInfo(), ERRORINFO_BINDING);
            protocolMarshaller.marshall(otaUpdateInfo.additionalParameters(), ADDITIONALPARAMETERS_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

