/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.transform;

import java.time.Instant;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.iot.model.OTAUpdateSummary;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class OTAUpdateSummaryMarshaller {
    private static final MarshallingInfo<String> OTAUPDATEID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("otaUpdateId").isBinary(false).build();
    private static final MarshallingInfo<String> OTAUPDATEARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("otaUpdateArn").isBinary(false).build();
    private static final MarshallingInfo<Instant> CREATIONDATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("creationDate").isBinary(false).build();
    private static final OTAUpdateSummaryMarshaller INSTANCE = new OTAUpdateSummaryMarshaller();

    private OTAUpdateSummaryMarshaller() {
    }

    public static OTAUpdateSummaryMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(OTAUpdateSummary otaUpdateSummary, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)otaUpdateSummary, (String)"otaUpdateSummary");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)otaUpdateSummary.otaUpdateId(), OTAUPDATEID_BINDING);
            protocolMarshaller.marshall((Object)otaUpdateSummary.otaUpdateArn(), OTAUPDATEARN_BINDING);
            protocolMarshaller.marshall((Object)otaUpdateSummary.creationDate(), CREATIONDATE_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

