/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.iot.model.PolicyVersionIdentifier;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class PolicyVersionIdentifierMarshaller {
    private static final MarshallingInfo<String> POLICYNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("policyName").isBinary(false).build();
    private static final MarshallingInfo<String> POLICYVERSIONID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("policyVersionId").isBinary(false).build();
    private static final PolicyVersionIdentifierMarshaller INSTANCE = new PolicyVersionIdentifierMarshaller();

    private PolicyVersionIdentifierMarshaller() {
    }

    public static PolicyVersionIdentifierMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(PolicyVersionIdentifier policyVersionIdentifier, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)policyVersionIdentifier, (String)"policyVersionIdentifier");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)policyVersionIdentifier.policyName(), POLICYNAME_BINDING);
            protocolMarshaller.marshall((Object)policyVersionIdentifier.policyVersionId(), POLICYVERSIONID_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

