/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.iot.model.PresignedUrlConfig;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class PresignedUrlConfigMarshaller {
    private static final MarshallingInfo<String> ROLEARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("roleArn").isBinary(false).build();
    private static final MarshallingInfo<Long> EXPIRESINSEC_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("expiresInSec").isBinary(false).build();
    private static final PresignedUrlConfigMarshaller INSTANCE = new PresignedUrlConfigMarshaller();

    private PresignedUrlConfigMarshaller() {
    }

    public static PresignedUrlConfigMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(PresignedUrlConfig presignedUrlConfig, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)presignedUrlConfig, (String)"presignedUrlConfig");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)presignedUrlConfig.roleArn(), ROLEARN_BINDING);
            protocolMarshaller.marshall((Object)presignedUrlConfig.expiresInSec(), EXPIRESINSEC_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

