/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.iot.model.ReplaceTopicRuleRequest;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class ReplaceTopicRuleRequestModelMarshaller {
    private static final MarshallingInfo<String> RULENAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PATH).marshallLocationName("ruleName").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> TOPICRULEPAYLOAD_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).isExplicitPayloadMember(true).isBinary(false).build();
    private static final ReplaceTopicRuleRequestModelMarshaller INSTANCE = new ReplaceTopicRuleRequestModelMarshaller();

    private ReplaceTopicRuleRequestModelMarshaller() {
    }

    public static ReplaceTopicRuleRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(ReplaceTopicRuleRequest replaceTopicRuleRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)((Object)replaceTopicRuleRequest), (String)"replaceTopicRuleRequest");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)replaceTopicRuleRequest.ruleName(), RULENAME_BINDING);
            protocolMarshaller.marshall((Object)replaceTopicRuleRequest.topicRulePayload(), TOPICRULEPAYLOAD_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

