/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.iot.model.RepublishAction;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class RepublishActionMarshaller {
    private static final MarshallingInfo<String> ROLEARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("roleArn").isBinary(false).build();
    private static final MarshallingInfo<String> TOPIC_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("topic").isBinary(false).build();
    private static final RepublishActionMarshaller INSTANCE = new RepublishActionMarshaller();

    private RepublishActionMarshaller() {
    }

    public static RepublishActionMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(RepublishAction republishAction, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)republishAction, (String)"republishAction");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)republishAction.roleArn(), ROLEARN_BINDING);
            protocolMarshaller.marshall((Object)republishAction.topic(), TOPIC_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

