/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.transform;

import java.time.Instant;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.iot.model.RoleAliasDescription;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class RoleAliasDescriptionMarshaller {
    private static final MarshallingInfo<String> ROLEALIAS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("roleAlias").isBinary(false).build();
    private static final MarshallingInfo<String> ROLEALIASARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("roleAliasArn").isBinary(false).build();
    private static final MarshallingInfo<String> ROLEARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("roleArn").isBinary(false).build();
    private static final MarshallingInfo<String> OWNER_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("owner").isBinary(false).build();
    private static final MarshallingInfo<Integer> CREDENTIALDURATIONSECONDS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("credentialDurationSeconds").isBinary(false).build();
    private static final MarshallingInfo<Instant> CREATIONDATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("creationDate").isBinary(false).build();
    private static final MarshallingInfo<Instant> LASTMODIFIEDDATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("lastModifiedDate").isBinary(false).build();
    private static final RoleAliasDescriptionMarshaller INSTANCE = new RoleAliasDescriptionMarshaller();

    private RoleAliasDescriptionMarshaller() {
    }

    public static RoleAliasDescriptionMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(RoleAliasDescription roleAliasDescription, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)roleAliasDescription, (String)"roleAliasDescription");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)roleAliasDescription.roleAlias(), ROLEALIAS_BINDING);
            protocolMarshaller.marshall((Object)roleAliasDescription.roleAliasArn(), ROLEALIASARN_BINDING);
            protocolMarshaller.marshall((Object)roleAliasDescription.roleArn(), ROLEARN_BINDING);
            protocolMarshaller.marshall((Object)roleAliasDescription.owner(), OWNER_BINDING);
            protocolMarshaller.marshall((Object)roleAliasDescription.credentialDurationSeconds(), CREDENTIALDURATIONSECONDS_BINDING);
            protocolMarshaller.marshall((Object)roleAliasDescription.creationDate(), CREATIONDATE_BINDING);
            protocolMarshaller.marshall((Object)roleAliasDescription.lastModifiedDate(), LASTMODIFIEDDATE_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

