/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.iot.model.S3Destination;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class S3DestinationMarshaller {
    private static final MarshallingInfo<String> BUCKET_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("bucket").isBinary(false).build();
    private static final MarshallingInfo<String> PREFIX_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("prefix").isBinary(false).build();
    private static final S3DestinationMarshaller INSTANCE = new S3DestinationMarshaller();

    private S3DestinationMarshaller() {
    }

    public static S3DestinationMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(S3Destination s3Destination, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)s3Destination, (String)"s3Destination");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)s3Destination.bucket(), BUCKET_BINDING);
            protocolMarshaller.marshall((Object)s3Destination.prefix(), PREFIX_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

