/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.transform;

import com.fasterxml.jackson.core.JsonToken;
import software.amazon.awssdk.core.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.iot.model.S3Destination;

public class S3DestinationUnmarshaller
implements Unmarshaller<S3Destination, JsonUnmarshallerContext> {
    private static final S3DestinationUnmarshaller INSTANCE = new S3DestinationUnmarshaller();

    public S3Destination unmarshall(JsonUnmarshallerContext context) throws Exception {
        S3Destination.Builder s3DestinationBuilder = S3Destination.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("bucket", targetDepth)) {
                    context.nextToken();
                    s3DestinationBuilder.bucket((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("prefix", targetDepth)) {
                    context.nextToken();
                    s3DestinationBuilder.prefix((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (S3Destination)s3DestinationBuilder.build();
    }

    public static S3DestinationUnmarshaller getInstance() {
        return INSTANCE;
    }
}

